<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','customers'])); ?>"> Customers</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
            </ol>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('customers.store', [])); ?>" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="name" class="form-label">Name:</label>
                        <input type="text" name="name" id="name" class="form-control" value="<?php echo e(@old('name')); ?>" required/>
                        <?php if($errors->has('name')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('name')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="address" class="form-label">Address:</label>
                        <input type="text" name="address" id="address" class="form-control" value="<?php echo e(@old('address')); ?>" />
                        <?php if($errors->has('address')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('address')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="email" class="form-label">Email:</label>
                        <input type="email" name="email" id="email" class="form-control" value="<?php echo e(@old('email')); ?>" />
                        <?php if($errors->has('email')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('email')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="phone_no" class="form-label">Phone No:</label>
                        <input type="text" name="phone_no" id="phone_no" class="form-control" value="<?php echo e(@old('phone_no')); ?>" />
                        <?php if($errors->has('phone_no')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('phone_no')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="alt_phone_no" class="form-label">Alt Phone No:</label>
                        <input type="text" name="alt_phone_no" id="alt_phone_no" class="form-control" value="<?php echo e(@old('alt_phone_no')); ?>" />
                        <?php if($errors->has('alt_phone_no')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('alt_phone_no')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-4">
                        <label for="tin" class="form-label">Tin:</label>
                        <input type="text" name="tin" id="tin" class="form-control" value="<?php echo e(@old('tin')); ?>" />
                        <?php if($errors->has('tin')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('tin')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-4">
                        <label for="password" class="form-label">Password:</label>
                        <input type="password" name="password" id="password" class="form-control" value="<?php echo e(@old('password')); ?>" />
                        <?php if($errors->has('password')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('password')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-4">
                        <label for="balance" class="form-label">Balance:</label>
                        <input type="number" name="balance" id="balance" class="form-control" value="<?php echo e(@old('balance')); ?>" required/>
                        <?php if($errors->has('balance')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('balance')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="row">
                        <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-group col-md-3">
                                <input type="checkbox" id="tax_<?php echo e($tax->id); ?>" name="taxes[]" value="<?php echo e($tax->id); ?>">
                                <label class="form-label" for="tax_<?php echo e($tax->id); ?>"><?php echo e($tax->name); ?></label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('customers.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Customer'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/customers/create.blade.php ENDPATH**/ ?>