<?php $__env->startSection('purchases.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Purchases</h5>

            <a href="<?php echo e(route('purchases.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Purchase'); ?></a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Supplier</th>
                        <th role='columnheader'>Items</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Supplier"><a href="<?php echo e(implode('/', ['','suppliers',$purchase->supplier_id ?: 0])); ?>" class="text-dark"><?php echo e($purchase?->supplier?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Items"><a href="<?php echo e(implode('/', ['','items',$purchase->items_id ?: 0])); ?>" class="text-dark"><?php echo e($purchase?->item?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Payment Method"><a href="<?php echo e(implode('/', ['','payment_methods',$purchase->payment_method_id ?: 0])); ?>" class="text-dark"><?php echo e($purchase?->payment_method?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Amount"><?php echo e($purchase->amount ?: "(blank)"); ?></td>
                        <td data-label="Balance"><?php echo e($purchase->balance ?: 0); ?></td>

                        <td data-label="Actions:" class="text-nowrap">
                         <?php if($purchase->trashed()): ?>
                         <form action="<?php echo e(route('purchases.restore', ['purchase' => $purchase])); ?>" method="POST" class="d-inline-block me-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="<?php echo e(route('purchases.purge', ['purchase' => $purchase])); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                        </form>
                        <?php else: ?>
                        <a href="<?php echo e(route('purchases.show', compact('purchase'))); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('purchases.edit', compact('purchase'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                <li>
                                    <form action="<?php echo e(route('purchases.destroy', compact('purchase'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        
    </div>
    <div class="text-center my-2">
        
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('purchases.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/purchases/index.blade.php ENDPATH**/ ?>