<?php $__env->startSection('content'); ?>
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="<?php echo e(($request->start_date) ? $request->start_date : date('Y-m-d')); ?>" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="<?php echo e(($request->end_date) ? $request->end_date : date('Y-m-d')); ?>" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>Items</label>
				<select class="form-select select2" name="user[]" multiple>
					<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($user->id); ?>" <?php echo e(($request->user) ? (in_array($user->id,$request->user) ? 'selected':''):''); ?>><?php echo e($user->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Purchases</h5>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover table-bordered dataTable">
                <thead role="rowgroup bg-light">
                    <tr role="row">
                        <th role='columnheader'>Date</th>
                        <th role='columnheader'>Supplier</th>
                        <th role='columnheader'>Item</th>
                        <th role='columnheader'>Amount</th>
                        
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(date('d M, Y',strtotime($expense->created_at))); ?></td>
                        <td data-label="Customer"><?php echo e($expense?->supplier?->name ?: "(blank)"); ?></td>
                        <td data-label="Payment_Method"><?php echo e($expense?->item?->name ?: "(blank)"); ?></td>
                        <td data-label="Gross Amount"><?php echo e(number_format($expense->amount) ?: "0"); ?></td>
                        
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/reports/purchases.blade.php ENDPATH**/ ?>