<?php $__env->startSection('expenseItems.content'); ?>
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','expense_items'])); ?>"> Expense Items</a></li>
                    <li class="breadcrumb-item"><?php echo app('translator')->get('Expense Item'); ?> #<?php echo e($expenseItem->id); ?></li>
                </ol>

                <a href="<?php echo e(route('expense_items.index', [])); ?>" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td><?php echo e($expenseItem->id); ?></td>
    </tr>
            <tr>
            <th scope="row">Name:</th>
            <td><?php echo e($expenseItem->name ?: "(blank)"); ?></td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td><?php echo e(Carbon\Carbon::parse($expenseItem->created_at)->format('d/m/Y H:i:s')); ?></td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td><?php echo e(Carbon\Carbon::parse($expenseItem->updated_at)->format('d/m/Y H:i:s')); ?></td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="<?php echo e(route('expense_items.edit', compact('expenseItem'))); ?>" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
                <form action="<?php echo e(route('expense_items.destroy', compact('expenseItem'))); ?>" method="POST" class="m-0 p-0">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('expense_items.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/expense_items/show.blade.php ENDPATH**/ ?>