<?php $__env->startSection('content'); ?>
<div class="card">
	<div class="card-header d-flex justify-content-between">
		<h5>Recent Analysis</h5>
		<a href="<?php echo e(url('analysis/create')); ?>" class="btn btn-primary">New Analysis</a>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table table-striped table dataTable">
				<thead class="table-light ">
					<th>Customer</th>
					<th>Records</th>
					<th>Progress</th>
					<th>Status</th>
					<th>Actions</th>
				</thead>
				<tbody>
					<?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td>
							<?php echo e($record?->customer?->name); ?>

						</td>
						<td>
							<?php echo e($record->total); ?>

						</td>
						<td>
							<?php echo e(number_format(($record->successful + $record->failed)).' of '.number_format($record->total)); ?>

						</td>
						<td>
							<?php echo e(($record->total - ($record->successful + $record->failed)) > 0 ? "Ongoing" : "Complete"); ?>

						</td>
						<td>
							<a href="<?php echo e(url('analysis/'.$record->id)); ?>" class="btn btn-primary btn-sm">Show</a>
						</td>
					</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customjs'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/analysis/index.blade.php ENDPATH**/ ?>