<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','monthly_fillings'])); ?>"> Monthly Fillings</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
            </ol>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('monthly_fillings.store', [])); ?>" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3 col-md-6">
                        <label for="customer_id" class="form-label">Customer:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="customer_id" id="customer_id" class="form-control form-select flex-grow-1 select2" required>
                                <option value="" selected disabled>Select Customer</option>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($customer->id); ?>" <?php echo e(@old('customer_id') == $customer->id ? "selected" : ""); ?>><?php echo e($customer->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <!-- <a class="btn btn-light text-nowrap" href="<?php echo e(url('customers')); ?>"><i class="fa fa-plus-circle"></i> New</a> -->
                        </div>
                        <?php if($errors->has('customer_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('customer_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="month" class="form-label">Month:</label>
                        <input type="date" name="month" id="month" class="form-control" value="<?php echo e(@old('month')); ?>"/>
                        <?php if($errors->has('month')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('month')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="standard_sales" class="form-label">Standard Sales:</label>
                        <input type="text" name="standard_sales" id="standard_sales" class="form-control" value="<?php echo e(@old('standard_sales')); ?>" />
                        <?php if($errors->has('standard_sales')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('standard_sales')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="deemed_sales" class="form-label">Deemed Sales:</label>
                        <input type="text" name="deemed_sales" id="deemed_sales" class="form-control" value="<?php echo e(@old('deemed_sales')); ?>" />
                        <?php if($errors->has('deemed_sales')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('deemed_sales')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="zero_rated_sales" class="form-label">Zero Rated Sales:</label>
                        <input type="text" name="zero_rated_sales" id="zero_rated_sales" class="form-control" value="<?php echo e(@old('zero_rated_sales')); ?>" />
                        <?php if($errors->has('zero_rated_sales')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('zero_rated_sales')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="exempted_sales" class="form-label">Exempted Sales:</label>
                        <input type="text" name="exempted_sales" id="exempted_sales" class="form-control" value="<?php echo e(@old('exempted_sales')); ?>" />
                        <?php if($errors->has('exempted_sales')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('exempted_sales')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="purchases" class="form-label">Purchases:</label>
                        <input type="text" name="purchases" id="purchases" class="form-control" value="<?php echo e(@old('purchases')); ?>" />
                        <?php if($errors->has('purchases')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('purchases')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="non_vat_urchases" class="form-label">Non VAT Purchases:</label>
                        <input type="text" name="non_vat_purchases" id="non_vat_purchases" class="form-control number_format" value="<?php echo e(@old('non_vat_purchases')); ?>" />
                        <?php if($errors->has('non_vat_purchases')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('non_vat_purchases')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="imports" class="form-label">Imports:</label>
                        <input type="text" name="imports" id="imports" class="form-control" value="<?php echo e(@old('imports')); ?>" />
                        <?php if($errors->has('imports')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('imports')); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="mb-3 col-md-6">
                        <label for="filling_date" class="form-label">Filling Date:</label>
                        <input type="date" name="filling_date" id="filling_date" class="form-control" value="<?php echo e(@old('filling_date')); ?>" />
                        <?php if($errors->has('filling_date')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('filling_date')); ?></div>
                        <?php endif; ?>
                    </div>
                    

                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('monthly_fillings.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Monthly Filling'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/monthly_fillings/create.blade.php ENDPATH**/ ?>