<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-8">
		<div class="card">
			<div class="card-header">
				<h5>All Users</h5>
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table class="table table-striped">
						<thead>
							<th>Name</th>
							<th>Email</th>
							<th>Joined</th>
							<th>Status</th>
							<th>Actions</th>
						</thead>
						<tbody>
							<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($user->name); ?></td>
								<td><?php echo e($user->email); ?></td>
								<td><?php echo e(date('d M, Y',strtotime($user->created_at))); ?></td>
								<td>
									<span class="badge bg-<?php echo e(($user->status == 'Enabled') ? 'primary' : 'danger'); ?>"><?php echo e($user->status); ?></span>
								</td>
								<td>
									<a href="<?php echo e(url('user_status/'.$user->id.'/'.(($user->status == 'Enabled') ? 'Disabled' : 'Enabled'))); ?>">
										<?php echo e((($user->status == 'Enabled') ? 'Disable' : 'Enable')); ?>

									</a>
									<a href="javascript:void(0);"  data-url="<?php echo e(url('user_permissions/'.$user->id)); ?>" class="ajax-load">Permissions</a>
								</td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4">
		<div class="card">
			<div class="card-header">
				<h5>Invitations</h5>
			</div>
			<form class="card-body" method="POST" action="invite_user">
				<?php echo csrf_field(); ?>
				<div class="form-group">
					<input type="text" name="email" placeholder="Email Address" class="form-control" value="<?php echo e(@old('email')); ?>" required>
				</div>
				<div class="text-end mt-1">
					<button class="btn btn-primary">Invite</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/settings/users/index.blade.php ENDPATH**/ ?>