<?php $__env->startSection('content'); ?>


<div class="card">
    <div class="card-header">
        <h5><?php echo e($customer->name); ?></h5>
    </div>
    <div class="card-body">
        <!-- Nav tabs -->
        <ul class="nav nav-pills nav-justified mb-3" role="tablist">
            <li class="nav-item waves-effect waves-light">
                <a class="nav-link active" data-bs-toggle="tab" href="#pill-justified-home-1" role="tab">
                    Overview
                </a>
            </li>
            <li class="nav-item waves-effect waves-light">
                <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-profile-1" role="tab">
                    Invoices
                </a>
            </li>
            <li class="nav-item waves-effect waves-light">
                <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-messages-1" role="tab">
                    Transactions
                </a>
            </li>
            
        </ul>
        <!-- Tab panes -->
        <div class="tab-content text-muted">
            <div class="tab-pane active" id="pill-justified-home-1" role="tabpanel">
                <table class="table table-striped">
                    <tbody>
                        <tr>
                            <th scope="row">Address:</th>
                            <td><?php echo e($customer->address ?: "(blank)"); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">Email:</th>
                            <td><?php echo e($customer->email ?: "(blank)"); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">Phone No:</th>
                            <td><?php echo e($customer->phone_no ?: "(blank)"); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">Alt Phone No:</th>
                            <td><?php echo e($customer->alt_phone_no ?: "(blank)"); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">Tin:</th>
                            <td><?php echo e($customer->tin ?: "(blank)"); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">Password:</th>
                            <td><?php echo e($customer->password ?: "(blank)"); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">Balance:</th>
                            <td><?php echo e(number_format($customer->balance) ?: "(blank)"); ?></td>
                        </tr>
                    </tbody>
                </table>

                <div class="row">
                    <?php $__currentLoopData = $customer->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4">
                        <?php echo e($tax->name); ?>

                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane" id="pill-justified-profile-1" role="tabpanel">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered dataTable">
                        <thead role="rowgroup bg-light">
                            <tr role="row">
                                <th role='columnheader'>Invoice No</th>
                                <th role='columnheader'>Issue Date</th>
                                <th role='columnheader'>Gross Amount</th>
                                <th role='columnheader'>Sales Person</th>
                                <th role='columnheader'>Status</th>
                                <th role='columnheader'>Created By</th>
                                <th scope="col" data-label="Actions">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customer->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td data-label="Invoice No">INV<?php echo e(sprintf("%05d",$invoice->invoice_no) ?: "(blank)"); ?></td>
                                <td data-label="Issue Date"><?php echo e($invoice->issue_date ?: "(blank)"); ?></td>
                                <td data-label="Gross Amount"><?php echo e(number_format($invoice->gross_amount) ?: "(blank)"); ?></td>
                                <td data-label="Sales Person"><?php echo e($invoice->sales_person ?: "(blank)"); ?></td>
                                <td data-label="Status">
                                    <span class="badge <?php echo e(($invoice->status == "Completed") ? "bg-primary" : "bg-warning"); ?>"><?php echo e($invoice->status ?: "(blank)"); ?></span>
                                </td>
                                <td data-label="Created By"><?php echo e($invoice->user->name ?: "(blank)"); ?></td>

                                <td data-label="Actions:" class="text-nowrap">
                                 <?php if($invoice->trashed()): ?>
                                 <form action="<?php echo e(route('invoices.restore', ['invoice' => $invoice])); ?>" method="POST" class="d-inline-block me-2">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                                </form>
                                <form action="<?php echo e(route('invoices.purge', ['invoice' => $invoice])); ?>" method="POST" class="d-inline-block">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                                </form>
                                <?php else: ?>
                                <a href="<?php echo e(route('invoices.show', compact('invoice'))); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                                <?php if($invoice->status == "Draft"): ?>
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="<?php echo e(route('invoices.edit', compact('invoice'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                        <li>
                                            <form action="<?php echo e(route('invoices.destroy', compact('invoice'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                                <?php endif; ?>

                                <?php endif; ?>

                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane" id="pill-justified-messages-1" role="tabpanel">
            <div class="table-responsive ">
            <table class="table table-striped table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th role='columnheader'>Received By</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $customer->invoice_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>INV<?php echo e(sprintf("%05d",$payment->invoice->invoice_no)); ?></td>
                            <td><?php echo e($payment->amount); ?></td>
                            <td><?php echo e($payment->balance); ?></td>
                            <td><?php echo e($payment->user->name); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        </div>
        <div class="tab-pane" id="pill-justified-settings-1" role="tabpanel">
            <div class="d-flex mt-2">
                <div class="flex-shrink-0">
                    <i class="ri-checkbox-circle-fill text-success"></i>
                </div>
                <div class="flex-grow-1 ms-2">
                    For that very reason, I went on a quest and spoke to many different professional graphic designers and asked them what graphic design tips they live.
                </div>
            </div>
            <div class="d-flex mt-2">
                <div class="flex-shrink-0">
                    <i class="ri-checkbox-circle-fill text-success"></i>
                </div>
                <div class="flex-grow-1 ms-2">
                    After gathering lots of different opinions and graphic design basics, I came up with a list of 30 graphic design tips that you can start implementing.
                </div>
            </div>
        </div>
    </div>
</div><!-- end card-body -->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/customers/show.blade.php ENDPATH**/ ?>