<?php $__env->startSection('suppliers.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','suppliers'])); ?>"> Suppliers</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
            </ol>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('suppliers.store', [])); ?>" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="name" class="form-label">Name:</label>
                        <input type="text" name="name" id="name" class="form-control" value="<?php echo e(@old('name')); ?>" required/>
                        <?php if($errors->has('name')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('name')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="contacts" class="form-label">Contacts:</label>
                        <input type="text" name="contacts" id="contacts" class="form-control" value="<?php echo e(@old('contacts')); ?>" />
                        <?php if($errors->has('contacts')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('contacts')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="address" class="form-label">Address:</label>
                        <input type="text" name="address" id="address" class="form-control" value="<?php echo e(@old('address')); ?>" />
                        <?php if($errors->has('address')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('address')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="tin" class="form-label">Tin:</label>
                        <input type="text" name="tin" id="tin" class="form-control" value="<?php echo e(@old('tin')); ?>" />
                        <?php if($errors->has('tin')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('tin')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="balance" class="form-label">Balance:</label>
                        <input type="text" name="balance" id="balance" class="form-control" value="<?php echo e(@old('balance')); ?>" required/>
                        <?php if($errors->has('balance')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('balance')); ?></div>
                        <?php endif; ?>
                    </div>

                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('suppliers.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Supplier'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('suppliers.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/suppliers/create.blade.php ENDPATH**/ ?>