<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="card col-md-12">
		<div class="card-header">
			<h5>Analysis Details</h5>
		</div>
		<div class="card-body">
			<div class="row">
				<div class="col-md-4 mb-3">
					<label>Customer</label>
					<div><?php echo e($analysis?->customer?->name); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Name</label>
					<div><?php echo e($analysis?->name); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Records</label>
					<div><?php echo e($analysis?->total); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Successful</label>
					<div><?php echo e(number_format($analysis?->successful)); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Failed</label>
					<div><?php echo e(number_format($analysis?->failed)); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Progress</label>
					<div><?php echo e(number_format($analysis?->successful + $analysis->failed) . " / ".$analysis->total); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Input VAT</label>
					<div><?php echo e($analysis?->purchases?->vat); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Output VAT</label>
					<div><?php echo e($analysis?->sales?->vat); ?></div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Payable VAT</label>
					<div><?php echo e(number_format((str_replace(',', '', $analysis?->sales?->vat) - str_replace(',', '', $analysis->purchases->vat)),2)); ?></div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-6">
		<div class="card">
			<div class="card-header">
				<h5>Purchases</h5>
			</div>
			<div class="card-body">
				<table class="table table-striped">
					<tbody>
						<tr>
							<th>Standard Purchases</th>
							<td><?php echo e($analysis->purchases->standard_sales); ?></td>
						</tr>
						<tr>
							<th>Deemed Purchases</th>
							<td><?php echo e($analysis->purchases->deemed_sales); ?></td>
						</tr>
						<tr>
							<th>Exempted Purchases</th>
							<td><?php echo e($analysis->purchases->exempted_sales); ?></td>
						</tr>
						<tr>
							<th>Zero Rated Purchases</th>
							<td><?php echo e($analysis->purchases->zero_rated_sales); ?></td>
						</tr>
						<tr>
							<th>Total VAT</th>
							<td><?php echo e($analysis?->purchases?->vat); ?></td>
						</tr>
						<tr>
							<th>Total Records</th>
							<td><?php echo e($analysis?->purchases->total_count); ?></td>
						</tr>
						<tr>
							<th>Failed</th>
							<td>
								<?php $__currentLoopData = $analysis->purchases->failed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $failed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<a href="<?php echo e(url('analysis/'.$failed->fdn.'/edit')); ?>" class="me-4"><?php echo e($failed->fdn); ?></a>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<div class="col-md-6">
		<div class="card">
			<div class="card-header">
				<h5>Sales</h5>
			</div>
			<div class="card-body">
				<table class="table table-striped">
					<tbody>
						<tr>
							<th>Standard Sales</th>
							<td><?php echo e($analysis->sales->standard_sales); ?></td>
						</tr>
						<tr>
							<th>Deemed Sales</th>
							<td><?php echo e($analysis->sales->deemed_sales); ?></td>
						</tr>
						<tr>
							<th>Exempted Sales</th>
							<td><?php echo e($analysis->sales->exempted_sales); ?></td>
						</tr>
						<tr>
							<th>Zero Rated Sales</th>
							<td><?php echo e($analysis->sales->zero_rated_sales); ?></td>
						</tr>
						<tr>
							<th>Total VAT</th>
							<td><?php echo e($analysis?->sales?->vat); ?></td>
						</tr>
						<tr>
							<th>Total Records</th>
							<td><?php echo e($analysis?->sales->total_count); ?></td>
						</tr>
						<tr>
							<th>Failed</th>
							<td>
								<?php $__currentLoopData = $analysis->sales->failed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $failed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<a href="<?php echo e(url('analysis/'.$failed->fdn.'/edit')); ?>" class="me-4"><?php echo e($failed->fdn); ?></a>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/analysis/details.blade.php ENDPATH**/ ?>