<?php $__env->startSection('expenses.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Expenses</h5>

            <
            <a href="<?php echo e(route('expenses.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Expense'); ?></a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Expense Item</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Expense Date</th>
                        <th role='columnheader'>Amount</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Expense Item"><a href="<?php echo e(implode('/', ['','expense_items',$expense->expense_item_id ?: 0])); ?>" class="text-dark"><?php echo e($expense?->expense_item?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Payment Method"><a href="<?php echo e(implode('/', ['','payment_methods',$expense->payment_method_id ?: 0])); ?>" class="text-dark"><?php echo e($expense?->payment_method?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Expense Date"><?php echo e($expense->expense_date ?: "(blank)"); ?></td>
                        <td data-label="Amount"><?php echo e($expense->amount ? number_format($expense->amount) : "(blank)"); ?></td>

                        <td data-label="Actions:" class="text-nowrap">
                         <?php if($expense->trashed()): ?>
                         <form action="<?php echo e(route('expenses.restore', ['expense' => $expense])); ?>" method="POST" class="d-inline-block me-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="<?php echo e(route('expenses.purge', ['expense' => $expense])); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                        </form>
                        <?php else: ?>
                        <a href="<?php echo e(route('expenses.show', compact('expense'))); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('expenses.edit', compact('expense'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                <li>
                                    <form action="<?php echo e(route('expenses.destroy', compact('expense'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        
    </div>
    <div class="text-center my-2">
        <a href="<?php echo e(route('expenses.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Expense'); ?></a>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('expenses.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/expenses/index.blade.php ENDPATH**/ ?>