@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
                <ol class="breadcrumb m-0 p-0 flex-grow-1 mb-2 mb-md-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','taxes']) }}"> Taxes</a></li>
                </ol>

                <form action="{{ route('taxes.index', []) }}" method="GET" class="m-0 p-0">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-sm me-2" name="search" placeholder="Search Taxes..." value="{{ request()->search }}">
                        <span class="input-group-btn">
                            <button class="btn btn-info btn-sm" type="submit"><i class="fa fa-search"></i> @lang('Go!')</button>
                        </span>
                    </div>
                </form>
            </div>
            <div class="card-body">
                <table class="table table-striped table-responsive table-hover">
    <thead role="rowgroup">
    <tr role="row">
                    <th role='columnheader'>Name</th>
                <th scope="col" data-label="Actions">Actions</th>
    </tr>
    </thead>
    <tbody>
    @foreach($taxes as $tax)
        <tr>
                            <td data-label="Name">{{ $tax->name ?: "(blank)" }}</td>

            <td data-label="Actions:" class="text-nowrap">
                                   @if($tax->trashed())
    <form action="{{ route('taxes.restore', ['tax' => $tax]) }}" method="POST" class="d-inline-block me-2">
        @csrf
        @method('PUT')
        <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
    </form>
    <form action="{{ route('taxes.purge', ['tax' => $tax]) }}" method="POST" class="d-inline-block">
        @csrf
        @method('DELETE')
        <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
    </form>
@else
    <a href="{{route('taxes.show', compact('tax'))}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
<div class="btn-group btn-group-sm">
    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
    <ul class="dropdown-menu">
        <li><a class="dropdown-item" href="{{route('taxes.edit', compact('tax'))}}">@lang('Edit')</a></li>
        <li>
            <form action="{{route('taxes.destroy', compact('tax'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                @csrf
                @method('DELETE')
                <button type="submit" class="dropdown-item">@lang('Delete')</button>
            </form>
        </li>
    </ul>
</div>

@endif

                            </td>
        </tr>
    @endforeach
    </tbody>
</table>

                {{ $taxes->withQueryString()->links() }}
            </div>
            <div class="text-center my-2">
                <a href="{{ route('taxes.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Tax')</a>
            </div>
        </div>
    </div>
@endsection
