@extends('suppliers.layout')

@section('suppliers.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','suppliers']) }}"> Suppliers</a></li>
                    <li class="breadcrumb-item">@lang('Supplier') #{{$supplier->id}}</li>
                </ol>

                <a href="{{ route('suppliers.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td>{{$supplier->id}}</td>
    </tr>
            <tr>
            <th scope="row">Name:</th>
            <td>{{ $supplier->name ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Contacts:</th>
            <td>{{ $supplier->contacts ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Address:</th>
            <td>{{ $supplier->address ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Tin:</th>
            <td>{{ $supplier->tin ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Balance:</th>
            <td>{{ $supplier->balance ?: "(blank)" }}</td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td>{{Carbon\Carbon::parse($supplier->created_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td>{{Carbon\Carbon::parse($supplier->updated_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="{{ route('suppliers.edit', compact('supplier')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
                <form action="{{ route('suppliers.destroy', compact('supplier')) }}" method="POST" class="m-0 p-0">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
                </form>
            </div>
        </div>
    </div>
@endsection
