@extends('layouts.app')
@section('content')
<div class="row">
	<div class="col-md-8">
		<div class="card">
			<div class="card-header">
				<h5>All Users</h5>
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table class="table table-striped">
						<thead>
							<th>Name</th>
							<th>Email</th>
							<th>Joined</th>
							<th>Status</th>
							<th>Actions</th>
						</thead>
						<tbody>
							@foreach($users as $user)
							<tr>
								<td>{{ $user->name }}</td>
								<td>{{ $user->email }}</td>
								<td>{{ date('d M, Y',strtotime($user->created_at)) }}</td>
								<td>
									<span class="badge bg-{{ ($user->status == 'Enabled') ? 'primary' : 'danger' }}">{{ $user->status }}</span>
								</td>
								<td>
									<a href="{{ url('user_status/'.$user->id.'/'.(($user->status == 'Enabled') ? 'Disabled' : 'Enabled')) }}">
										{{ (($user->status == 'Enabled') ? 'Disable' : 'Enable') }}
									</a>
									<a href="javascript:void(0);"  data-url="{{ url('user_permissions/'.$user->id) }}" class="ajax-load">Permissions</a>
								</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4">
		<div class="card">
			<div class="card-header">
				<h5>Invitations</h5>
			</div>
			<form class="card-body" method="POST" action="invite_user">
				@csrf
				<div class="form-group">
					<input type="text" name="email" placeholder="Email Address" class="form-control" value="{{ @old('email') }}" required>
				</div>
				<div class="text-end mt-1">
					<button class="btn btn-primary">Invite</button>
				</div>
			</form>
		</div>
	</div>
</div>
@endsection