@extends('layouts.app')

@section('content')
{{-- <div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="{{ implode('/', ['','invoices']) }}"> Invoices</a></li>
                <li class="breadcrumb-item">@lang('Invoice') #{{$invoice->id}}</li>
            </ol>

            <a href="{{ route('invoices.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
        </div>

        <div class="card-body">
            <table class="table table-striped">
                <tbody>
                    <tr>
                        <th scope="row">ID:</th>
                        <td>{{$invoice->id}}</td>
                    </tr>
                    <tr>
                        <th scope="row">Type:</th>
                        <td>{{ $invoice->type ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Project:</th>
                        <td>{{ $invoice->project_id ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Invoice No:</th>
                        <td>{{ $invoice->invoice_no ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Customer:</th>
                        <td><a href="{{implode('/', ['','customers',$invoice->customer_id ?: 0])}}" class="text-dark">{{$invoice?->customer?->name ?: "(blank)"}}</a></td>
                    </tr>
                    <tr>
                        <th scope="row">Issue Date:</th>
                        <td>{{ $invoice->issue_date ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Subject:</th>
                        <td>{{ $invoice->subject ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Reference:</th>
                        <td>{{ $invoice->reference ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Due Date:</th>
                        <td>{{ $invoice->due_date ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Send Date:</th>
                        <td>{{ $invoice->send_date ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Ref Number:</th>
                        <td>{{ Str::limit($invoice->ref_number, 50) ?: "(blank)"}}</td>
                    </tr>
                    <tr>
                        <th scope="row">Shipping Display:</th>
                        <td>{{ $invoice->shipping_display ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Discount Apply:</th>
                        <td>{{ $invoice->discount_apply ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Next Invoicing Date:</th>
                        <td>{{ $invoice->next_invoicing_date ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Paid:</th>
                        <td>{{ $invoice->paid ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Balance:</th>
                        <td>{{ $invoice->balance ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Net Amount:</th>
                        <td>{{ $invoice->net_amount ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Vat:</th>
                        <td>{{ $invoice->vat ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Gross Amount:</th>
                        <td>{{ $invoice->gross_amount ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Sales Person:</th>
                        <td>{{ $invoice->sales_person ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Customer Notes:</th>
                        <td>{{ Str::limit($invoice->customer_notes, 50) ?: "(blank)"}}</td>
                    </tr>
                    <tr>
                        <th scope="row">T C:</th>
                        <td>{{ Str::limit($invoice->t_c, 50) ?: "(blank)"}}</td>
                    </tr>
                    <tr>
                        <th scope="row">Payment Method:</th>
                        <td>{{ $invoice->payment_method_id ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Status:</th>
                        <td>{{ $invoice->status ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Created By:</th>
                        <td>{{ $invoice->created_by ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Created at</th>
                        <td>{{Carbon\Carbon::parse($invoice->created_at)->format('d/m/Y H:i:s')}}</td>
                    </tr>
                    <tr>
                        <th scope="row">Updated at</th>
                        <td>{{Carbon\Carbon::parse($invoice->updated_at)->format('d/m/Y H:i:s')}}</td>
                    </tr>
                </tbody>
            </table>

        </div>

        <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
            <a href="{{ route('invoices.edit', compact('invoice')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
            <form action="{{ route('invoices.destroy', compact('invoice')) }}" method="POST" class="m-0 p-0">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
            </form>
        </div>
    </div>
</div> --}}
<div class="row justify-content-center">
    <div class="col-xxl-9">
        <div class="card" id="demo">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card-header border-bottom-dashed p-4">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <h5 style="font-size: 30px; ">INVOICE</h5>
                                <div class="mt-sm-4 mt-3">
                                    <h6 class="text-muted text-uppercase fw-semibold">{{ $invoice->customer->name }}</h6>
                                    <p class="text-muted mb-1" id="address-details">
                                        {{ $invoice->customer->address }}
                                    </p>
                                    <p class="text-muted mb-0" id="zip-code">
                                        {{ $invoice->customer->phone_no }}
                                    </p>
                                </div>
                            </div>
                            <div class="flex-shrink-0 mt-sm-0 mt-3">
                                <h6><span id="legal-register-no">{{ env('BUSINESS_NAME') }}</span></h6>
                                <h6><span class="text-muted fw-normal">Email:</span><span id="email">
                                    {{ env('BUSINESS_EMAIL') }}
                                </span></h6>
                                <h6><span class="text-muted fw-normal">Website:</span> <a href="{{ env('BUSINESS_WEBSITE') }}" class="link-primary" target="_blank" id="website">{{ env('BUSINESS_WEBSITE') }}</a></h6>
                                <h6 class="mb-0"><span class="text-muted fw-normal">Contact No: </span><span id="contact-no"> {{ env('BUSINESS_CONTACT') }}</span></h6>
                            </div>
                        </div>
                    </div>
                    <!--end card-header-->
                </div><!--end col-->
                <div class="col-lg-12">
                    <div class="card-body p-4">
                        <div class="row g-3">
                            <div class="col-lg-6 col-6">
                                <p class="text-muted mb-2 text-uppercase fw-semibold">Invoice No</p>
                                <h5 class="fs-14 mb-0">#INV<span id="invoice-no">{{ sprintf('%05d',$invoice->invoice_no) }}</span></h5>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6 col-6">
                                <p class="text-muted mb-2 text-uppercase fw-semibold">Date</p>
                                <h5 class="fs-14 mb-0"><span id="invoice-date">{{ date("d M, Y",strtotime($invoice->created_at)) }}</span> <small class="text-muted" id="invoice-time">{{ date("h:i A",strtotime($invoice->created_at)) }}</small></h5>
                            </div>
                            <!--end col-->
                            {{-- <div class="col-lg-4 col-6">
                                <p class="text-muted mb-2 text-uppercase fw-semibold">Payment Status</p>
                                @if($invoice->balance == 0)
                                    <span class="badge badge-soft-success fs-11" id="payment-status">Fully Paid</span>
                                @elseif(($invoice->balance > 0) && ($invoice->balance < $invoice->gross_amount))
                                    <span class="badge badge-soft-warning fs-11" id="payment-status">Partially Paid</span>
                                @else
                                    <span class="badge badge-soft-danger fs-11" id="payment-status">Not paid</span>
                                @endif 
                                
                            </div>--}}
                            <!--end col-->
                            {{-- <div class="col-lg-3 col-6">
                                <p class="text-muted mb-2 text-uppercase fw-semibold">Total Amount</p>
                                <h5 class="fs-14 mb-0">$<span id="total-amount">755.96</span></h5>
                            </div> --}}
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </div>
                    <!--end card-body-->
                </div><!--end col-->
                {{--<div class="col-lg-12">
                    <div class="card-body p-4 border-top border-top-dashed">
                        <div class="row g-3">
                            <div class="col-6">
                                <h6 class="text-muted text-uppercase fw-semibold mb-3">Billing Address</h6>
                                <p class="fw-medium mb-2" id="billing-name">David Nichols</p>
                                <p class="text-muted mb-1" id="billing-address-line-1">305 S San Gabriel Blvd</p>
                                <p class="text-muted mb-1"><span>Phone: +</span><span id="billing-phone-no">(123) 456-7890</span></p>
                                <p class="text-muted mb-0"><span>Tax: </span><span id="billing-tax-no">12-3456789</span> </p>
                            </div>
                            <!--end col-->
                            <div class="col-6">
                                <h6 class="text-muted text-uppercase fw-semibold mb-3">Shipping Address</h6>
                                <p class="fw-medium mb-2" id="shipping-name">David Nichols</p>
                                <p class="text-muted mb-1" id="shipping-address-line-1">305 S San Gabriel Blvd</p>
                                <p class="text-muted mb-1"><span>Phone: +</span><span id="shipping-phone-no">(123) 456-7890</span></p>
                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </div>
                    <!--end card-body-->
                </div> --}}
                <div class="col-lg-12">
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            <table class="table table-borderless text-center table-nowrap align-middle mb-0">
                                <thead>
                                    <tr class="table-active">
                                        <th scope="col">Product Details</th>
                                        <th scope="col">Rate</th>
                                        <th scope="col">Quantity</th>
                                        <th scope="col" class="text-end">Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="products-list">
                                    @foreach($invoice->invoice_items as $invoice_item)
                                        <tr>
                                            <td class="text-start">
                                                <span class="fw-medium">{{ $invoice_item->item->name }}</span>
                                                <p class="text-muted mb-0">{{ $invoice_item->description }}</p>
                                            </td>
                                            <td>{{ $invoice_item->unit_price }}</td>
                                            <td>{{ $invoice_item->quantity }}</td>
                                            <td class="text-end">{{ $invoice_item->total }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table><!--end table-->
                        </div>
                        <div class="border-top border-top-dashed mt-2">
                            <table class="table table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:250px">
                                <tbody>
                                    <tr>
                                        <td>Sub Total</td>
                                        <td class="text-end">{{ $invoice->gross_amount }}</td>
                                    </tr>
                                    {{--<tr>
                                        <td>Discount</td>
                                        <td class="text-end"></td>
                                    </tr>
                                     <tr>
                                        <td>Estimated Tax (12.5%)</td>
                                        <td class="text-end">$44.99</td>
                                    </tr>
                                    
                                    <tr>
                                        <td>Shipping Charge</td>
                                        <td class="text-end">$65.00</td>
                                    </tr> --}}
                                    <tr class="border-top border-top-dashed fs-15">
                                        <th scope="row">Total Amount</th>
                                        <th class="text-end">{{ $invoice->gross_amount }}</th>
                                    </tr>
                                   {{--  <tr class=" bg-light">
                                        <td scope="row">Balance</td>
                                        <td class="text-end">{{ $invoice->balance }}</td>
                                    </tr> --}}
                                </tbody>
                            </table>
                            <!--end table-->
                        </div>
                       {{--  <div class="mt-3">
                            <h6 class="text-muted text-uppercase fw-semibold mb-3">Sales Details:</h6>
                            <p class="text-muted mb-1">Payment Method: <span class="fw-medium" id="payment-method">{{ $invoice?->payment_method?->name }}</span></p>
                            <p class="text-muted mb-1">Sales Person: <span class="fw-medium" id="card-holder-name">{{ $invoice?->sales_person }}</span></p>
                            <p class="text-muted mb-1">Due Date: <span class="fw-medium" id="card-number">{{ $invoice->due_date }}</span></p>
                            <p class="text-muted">Total Amount: <span class="fw-medium" id="">$ </span><span id="card-total-amount">755.96</span></p>
                        </div> --}}
                        <div class="mt-4">
                            <div class="alert alert-info">
                                <p class="mb-0"><span class="fw-semibold">NOTES:</span>
                                    {!! $invoice->t_c !!}
                                </p>
                            </div>
                        </div>
                        <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                            <a href="javascript:window.print()" class="btn btn-success"><i class="ri-printer-line align-bottom me-1"></i> Print</a>
                            <a href="{{ url('download_quotation/'.$invoice->id) }}" class="btn btn-primary"><i class="ri-download-2-line align-bottom me-1"></i> Download</a>
                        </div>
                    </div>
                    <!--end card-body-->
                </div><!--end col-->
            </div><!--end row-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>
@endsection
