@extends('layouts.app')
@section('content')
<div class="">
	<form method="POST" action="{{ url('send_invoice') }}">
		@csrf
		<div class="card">
			<div class="card-header bg-info text-light">
				<h5 class="modal-title text-white" id="composemodalTitle">New Message</h5>
			</div>
			<div class="card-body">
				<div>
					<input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
					<div class="mb-3 position-relative">
						<input type="text" name="recipients" class="form-control email-compose-input" data-choices data-choices-limit="15" value="{{ $invoice->customer->email }}" data-choices-removeItem placeholder="To">
						<div class="position-absolute top-0 end-0">
							<div class="d-flex">
								<button class="btn btn-link text-reset fw-semibold px-2" type="button" data-bs-toggle="collapse" data-bs-target="#CcRecipientsCollapse" aria-expanded="false" aria-controls="CcRecipientsCollapse">
									Cc
								</button>
								<button class="btn btn-link text-reset fw-semibold px-2" type="button" data-bs-toggle="collapse" data-bs-target="#BccRecipientsCollapse" aria-expanded="false" aria-controls="BccRecipientsCollapse">
									Bcc
								</button>
							</div>
						</div>
					</div>
					<div class="collapse" id="CcRecipientsCollapse">
						<div class="mb-3">
							<label>Cc:</label>
							<input type="text" name="cc_receipients" class="form-control" data-choices data-choices-limit="15" data-choices-removeItem placeholder="Cc recipients">
						</div>
					</div>
					<div class="collapse" id="BccRecipientsCollapse">
						<div class="mb-3">
							<label>Bcc:</label>
							<input type="text" class="form-control" name="bcc_receipients" value="finance@wykaconsults.com" data-choices data-choices-limit="15" data-choices-removeItem placeholder="Bcc recipients">
						</div>
					</div>

					<div class="mb-3">
						<input type="text" name="subject" class="form-control" value="Invoice From WYKA Consults" placeholder="Subject" required>
					</div>
					<div class="mb-1">
						<textarea class="ckeditor" name="body">{{ $email_body_template }}</textarea>
					</div>
					<h5>
						<span class="badge badge-xl bg-success">
							<i class="ri-attachment-2"></i> invoice.pdf
						</span>
					</h5>

				</div>
			</div>
			<div class="card-footer ">
				<div class="d-flex flex-row align-items-center justify-content-between mx-4">
					<button type="button" class="btn btn-danger" data-bs-dismiss="modal">Discard</button>

					<div class="btn-group">
						<button type="submit" class="btn btn-success">Send</button>
						<button type="button" class="btn btn-success dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
							<span class="visually-hidden">Toggle Dropdown</span>
						</button>
						<ul class="dropdown-menu dropdown-menu-end">
							<li><a class="dropdown-item" href="#"><i class="ri-timer-line text-muted me-1 align-bottom"></i> Schedule Send</a></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</form>
</div>
@endsection