@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="{{ ($request->start_date) ? $request->start_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="{{ ($request->end_date) ? $request->end_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>Items</label>
				<select class="form-select select2" name="user[]" multiple>
					@foreach($users as $user)
						<option value="{{ $user->id }}" {{ ($request->user) ? (in_array($user->id,$request->user) ? 'selected':''):''  }}>{{ $user->name }}</option>
					@endforeach
				</select>
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Purchases</h5>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover table-bordered dataTable">
                <thead role="rowgroup bg-light">
                    <tr role="row">
                        <th role='columnheader'>Date</th>
                        <th role='columnheader'>Supplier</th>
                        <th role='columnheader'>Item</th>
                        <th role='columnheader'>Amount</th>
                        {{-- <th role='columnheader'>Made By</th> --}}
                    </tr>
                </thead>
                <tbody>
                    @foreach($purchases as $expense)
                    <tr>
                        <td>{{ date('d M, Y',strtotime($expense->created_at)) }}</td>
                        <td data-label="Customer">{{$expense?->supplier?->name ?: "(blank)"}}</td>
                        <td data-label="Payment_Method">{{$expense?->item?->name ?: "(blank)"}}</td>
                        <td data-label="Gross Amount">{{ number_format($expense->amount) ?: "0" }}</td>
                        {{-- <td data-label="Sales Person">{{ $expense?->user?->name ?: "(blank)" }}</td> --}}
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection