@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="{{ ($request->start_date) ? $request->start_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="{{ ($request->end_date) ? $request->end_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
@if($summary->search)
<div class="card">
	<div class="card-body">
		<div class="table-responsive">
			<table class="table">
				<thead>
					<th>Item</th>
					<th class="text-end">Amount</th>
				</thead>
				<tr>
					<td>
						Sales
					</td>
					<td class="text-end">
						{{ number_format($summary->sales) }}
					</td>
				</tr>
				<tr>
					<td>
						Purchases
					</td>
					<td class="text-end">
						{{ number_format($summary->purchases) }}
					</td>
				</tr>
				<thead>
					<th>
						Gross Profit / Loss
					</th>
					<th class="text-end">
						{{ number_format($summary->sales - $summary->purchases) }}
					</th>
				</thead>
				<tr>
					<td>
						Expenses
					</td>
					<td class="text-end">
						{{ number_format($summary->expenses) }}
					</td>
				</tr>
				<thead>
					<th>
						Net Profit / Loss
					</th>
					<th class="text-end">
						{{ number_format(($summary->sales - $summary->purchases) - $summary->expenses) }}
					</th>
				</thead>
			</table>
		</div>
	</div>
</div>
@endif
@endsection