@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="{{ ($request->start_date) ? $request->start_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="{{ ($request->end_date) ? $request->end_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>Customer</label>
				<select class="form-select select2" name="customer" required>
					@foreach($customers as $customer)
						<option value="{{ $customer->id }}" {{ ($request->customer) ? (($customer->id == $request->customer) ? 'selected':'') : '' }}>{{ $customer->name }}</option>
					@endforeach
				</select>
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Customer Ledger</h5>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover table-bordered ">
                <thead role="rowgroup bg-light">
                    <tr role="row">
                        <th role='columnheader'>Date</th>
                        <th role='columnheader'>Type</th>
                        <th role='columnheader'>Credit</th>
                        <th role='columnheader'>Debit</th>
                        <th role='columnheader'>Balance</th> 
                    </tr>
                </thead>
                <tbody>
                	<tr>
                		<td colspan="4"><i>Balance B/F</i></td>
                		<td>{{ $balance }}</td>
                	</tr>
                    @foreach($entries as $entry)
                    <tr>
                        <td>{{ date('d M, Y',strtotime($entry->date)) }}</td>
                        <td data-label="Type">{{$entry->reference ?: "-"}}</td>
                        <td data-label="Payment_Method">{{$entry->credit ?: "-"}}</td>
                        <td data-label="Gross Amount">{{ $entry->debit ?: "-" }}</td>
                        <td data-label="Sales Person">{{ $entry->balance ?: "-" }}</td>
                	</tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection