@extends('purchases.layout')

@section('purchases.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','purchases']) }}"> Purchases</a></li>
                    <li class="breadcrumb-item">@lang('Purchase') #{{$purchase->id}}</li>
                </ol>

                <a href="{{ route('purchases.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td>{{$purchase->id}}</td>
    </tr>
            <tr>
            <th scope="row">Supplier:</th>
            <td><a href="{{implode('/', ['','suppliers',$purchase->supplier_id ?: 0])}}" class="text-dark">{{$purchase?->supplier?->name ?: "(blank)"}}</a></td>
        </tr>
            <tr>
            <th scope="row">Items:</th>
            <td><a href="{{implode('/', ['','items',$purchase->items_id ?: 0])}}" class="text-dark">{{$purchase?->items?->sku ?: "(blank)"}}</a></td>
        </tr>
            <tr>
            <th scope="row">Payment Method:</th>
            <td><a href="{{implode('/', ['','payment_methods',$purchase->payment_method_id ?: 0])}}" class="text-dark">{{$purchase?->payment_method?->name ?: "(blank)"}}</a></td>
        </tr>
            <tr>
            <th scope="row">Amount:</th>
            <td>{{ $purchase->amount ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Balance:</th>
            <td>{{ $purchase->balance ?: "(blank)" }}</td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td>{{Carbon\Carbon::parse($purchase->created_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td>{{Carbon\Carbon::parse($purchase->updated_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="{{ route('purchases.edit', compact('purchase')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
                <form action="{{ route('purchases.destroy', compact('purchase')) }}" method="POST" class="m-0 p-0">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
                </form>
            </div>
        </div>
    </div>
@endsection
