@extends('purchases.layout')

@section('purchases.content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Purchases</h5>

            <a href="{{ route('purchases.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Purchase')</a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Supplier</th>
                        <th role='columnheader'>Items</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($purchases as $purchase)
                    <tr>
                        <td data-label="Supplier"><a href="{{implode('/', ['','suppliers',$purchase->supplier_id ?: 0])}}" class="text-dark">{{$purchase?->supplier?->name ?: "(blank)"}}</a></td>
                        <td data-label="Items"><a href="{{implode('/', ['','items',$purchase->items_id ?: 0])}}" class="text-dark">{{$purchase?->item?->name ?: "(blank)"}}</a></td>
                        <td data-label="Payment Method"><a href="{{implode('/', ['','payment_methods',$purchase->payment_method_id ?: 0])}}" class="text-dark">{{$purchase?->payment_method?->name ?: "(blank)"}}</a></td>
                        <td data-label="Amount">{{ $purchase->amount ?: "(blank)" }}</td>
                        <td data-label="Balance">{{ $purchase->balance ?: 0 }}</td>

                        <td data-label="Actions:" class="text-nowrap">
                         @if($purchase->trashed())
                         <form action="{{ route('purchases.restore', ['purchase' => $purchase]) }}" method="POST" class="d-inline-block me-2">
                            @csrf
                            @method('PUT')
                            <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="{{ route('purchases.purge', ['purchase' => $purchase]) }}" method="POST" class="d-inline-block">
                            @csrf
                            @method('DELETE')
                            <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
                        </form>
                        @else
                        <a href="{{route('purchases.show', compact('purchase'))}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{route('purchases.edit', compact('purchase'))}}">@lang('Edit')</a></li>
                                <li>
                                    <form action="{{route('purchases.destroy', compact('purchase'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="dropdown-item">@lang('Delete')</button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        @endif

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        {{-- {{ $purchases->withQueryString()->links() }} --}}
    </div>
    <div class="text-center my-2">
        {{-- <a href="{{ route('purchases.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Purchase')</a> --}}
    </div>
</div>
</div>
@endsection
