@extends('purchase_payments.layout')

@section('purchasePayments.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','purchase_payments']) }}"> Purchase Payments</a></li>
                    <li class="breadcrumb-item">@lang('Edit Purchase Payment') #{{$purchasePayment->id}}</li>
                </ol>
            </div>
            <div class="card-body">
                <form action="{{ route('purchase_payments.update', compact('purchasePayment')) }}" method="POST" class="m-0 p-0">
                    @method('PUT')
                    @csrf
                    <div class="card-body">
                        <div class="mb-3">
        <label for="purchase_id" class="form-label">Purchase:</label>
        <div class="d-flex flex-row align-items-center justify-content-between">
    <select name="purchase_id" id="purchase_id" class="form-control form-select flex-grow-1" required>
        <option value="" selected disabled>Select Purchase</option>
        @foreach($purchases as $purchase)
            <option value="{{ $purchase->id }}" {{ @old('purchase_id', $purchasePayment->purchase_id) == $purchase->id ? "selected" : "" }}>{{ $purchase->amount }}</option>
        @endforeach
    </select>

    <a class="btn btn-light text-nowrap" href="{{implode('/', ['','purchases','create'])}}"><i class="fa fa-plus-circle"></i> New</a>
</div>
        @if($errors->has('purchase_id'))
			<div class='error small text-danger'>{{$errors->first('purchase_id')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="payment_method_id" class="form-label">Payment Method:</label>
        <div class="d-flex flex-row align-items-center justify-content-between">
    <select name="payment_method_id" id="payment_method_id" class="form-control form-select flex-grow-1" required>
        <option value="" selected disabled>Select Payment Method</option>
        @foreach($paymentMethods as $paymentMethod)
            <option value="{{ $paymentMethod->id }}" {{ @old('payment_method_id', $purchasePayment->payment_method_id) == $paymentMethod->id ? "selected" : "" }}>{{ $paymentMethod->name }}</option>
        @endforeach
    </select>

    <a class="btn btn-light text-nowrap" href="{{implode('/', ['','paymentMethods','create'])}}"><i class="fa fa-plus-circle"></i> New</a>
</div>
        @if($errors->has('payment_method_id'))
			<div class='error small text-danger'>{{$errors->first('payment_method_id')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="amount" class="form-label">Amount:</label>
        <input type="text" name="amount" id="amount" class="form-control" value="{{@old('amount', $purchasePayment->amount)}}" required/>
        @if($errors->has('amount'))
			<div class='error small text-danger'>{{$errors->first('amount')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="balance" class="form-label">Balance:</label>
        <input type="text" name="balance" id="balance" class="form-control" value="{{@old('balance', $purchasePayment->balance)}}" required/>
        @if($errors->has('balance'))
			<div class='error small text-danger'>{{$errors->first('balance')}}</div>
		@endif
    </div>

                    </div>
                    <div class="card-footer">
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <a href="{{ route('purchase_payments.index', []) }}" class="btn btn-light">Cancel</a>
                            <button type="submit" class="btn btn-primary">@lang('Update Purchase Payment')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
