@extends('items.layout')

@section('items.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','items']) }}"> Items</a></li>
                    <li class="breadcrumb-item">@lang('Item') #{{$item->id}}</li>
                </ol>

                <a href="{{ route('items.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td>{{$item->id}}</td>
    </tr>
            <tr>
            <th scope="row">Sku:</th>
            <td>{{ $item->sku ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Name:</th>
            <td>{{ $item->name ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Type:</th>
            <td>{{ $item->type ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Cost Price:</th>
            <td>{{ $item->cost_price ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Selling Price:</th>
            <td>{{ $item->selling_price ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Stock:</th>
            <td>{{ $item->stock ?: "(blank)" }}</td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td>{{Carbon\Carbon::parse($item->created_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td>{{Carbon\Carbon::parse($item->updated_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="{{ route('items.edit', compact('item')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
                <form action="{{ route('items.destroy', compact('item')) }}" method="POST" class="m-0 p-0">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
                </form>
            </div>
        </div>
    </div>
@endsection
