@extends('items.layout')

@section('items.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','items']) }}"> Items</a></li>
                    <li class="breadcrumb-item">@lang('Edit Item') #{{$item->id}}</li>
                </ol>
            </div>
            <div class="card-body">
                <form action="{{ route('items.update', compact('item')) }}" method="POST" class="m-0 p-0">
                    @method('PUT')
                    @csrf
                    <div class="card-body">
                        <div class="mb-3">
        <label for="sku" class="form-label">Sku:</label>
        <input type="text" name="sku" id="sku" class="form-control" value="{{@old('sku', $item->sku)}}" />
        @if($errors->has('sku'))
			<div class='error small text-danger'>{{$errors->first('sku')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="name" class="form-label">Name:</label>
        <input type="text" name="name" id="name" class="form-control" value="{{@old('name', $item->name)}}" required/>
        @if($errors->has('name'))
			<div class='error small text-danger'>{{$errors->first('name')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="type" class="form-label">Type:</label>
        <select name="type" id="type" class="form-control form-select" required>
    <option value="" selected disabled>Select Type</option>
    @foreach(["Product" => "Product", "Service" => "Service"] as $value => $label )
        <option value="{{ $value }}" {{ @old('type', $item->type) == $value ? "selected" : "" }}>{{ $label }}</option>
    @endforeach
</select>
        @if($errors->has('type'))
			<div class='error small text-danger'>{{$errors->first('type')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="cost_price" class="form-label">Cost Price:</label>
        <input type="number" name="cost_price" id="cost_price" class="form-control" value="{{@old('cost_price', $item->cost_price)}}" required/>
        @if($errors->has('cost_price'))
			<div class='error small text-danger'>{{$errors->first('cost_price')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="selling_price" class="form-label">Selling Price:</label>
        <input type="number" name="selling_price" id="selling_price" class="form-control" value="{{@old('selling_price', $item->selling_price)}}" required/>
        @if($errors->has('selling_price'))
			<div class='error small text-danger'>{{$errors->first('selling_price')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="stock" class="form-label">Stock:</label>
        <input type="number" name="stock" id="stock" class="form-control" value="{{@old('stock', $item->stock)}}" required/>
        @if($errors->has('stock'))
			<div class='error small text-danger'>{{$errors->first('stock')}}</div>
		@endif
    </div>

                    </div>
                    <div class="card-footer">
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <a href="{{ route('items.index', []) }}" class="btn btn-light">Cancel</a>
                            <button type="submit" class="btn btn-primary">@lang('Update Item')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
