@extends('expenses.layout')

@section('expenses.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','expenses']) }}"> Expenses</a></li>
                    <li class="breadcrumb-item">@lang('Expense') #{{$expense->id}}</li>
                </ol>

                <a href="{{ route('expenses.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td>{{$expense->id}}</td>
    </tr>
            <tr>
            <th scope="row">Expense Item:</th>
            <td><a href="{{implode('/', ['','expense_items',$expense->expense_item_id ?: 0])}}" class="text-dark">{{$expense?->expense_item?->name ?: "(blank)"}}</a></td>
        </tr>
            <tr>
            <th scope="row">Payment Method:</th>
            <td><a href="{{implode('/', ['','payment_methods',$expense->payment_method_id ?: 0])}}" class="text-dark">{{$expense?->payment_method?->name ?: "(blank)"}}</a></td>
        </tr>
            <tr>
            <th scope="row">Expense Date:</th>
            <td>{{ $expense->expense_date ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Amount:</th>
            <td>{{ $expense->amount ?: "(blank)" }}</td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td>{{Carbon\Carbon::parse($expense->created_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td>{{Carbon\Carbon::parse($expense->updated_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="{{ route('expenses.edit', compact('expense')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
                <form action="{{ route('expenses.destroy', compact('expense')) }}" method="POST" class="m-0 p-0">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
                </form>
            </div>
        </div>
    </div>
@endsection
