@extends('expenses.layout')

@section('expenses.content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Expenses</h5>

            <{{-- form action="{{ route('expenses.index', []) }}" method="GET" class="m-0 p-0">
                <div class="input-group">
                    <input type="text" class="form-control form-control-sm me-2" name="search" placeholder="Search Expenses..." value="{{ request()->search }}">
                    <span class="input-group-btn">
                        <button class="btn btn-info btn-sm" type="submit"><i class="fa fa-search"></i> @lang('Go!')</button>
                    </span>
                </div>
            </form> --}}
            <a href="{{ route('expenses.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Expense')</a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Expense Item</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Expense Date</th>
                        <th role='columnheader'>Amount</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($expenses as $expense)
                    <tr>
                        <td data-label="Expense Item"><a href="{{implode('/', ['','expense_items',$expense->expense_item_id ?: 0])}}" class="text-dark">{{$expense?->expense_item?->name ?: "(blank)"}}</a></td>
                        <td data-label="Payment Method"><a href="{{implode('/', ['','payment_methods',$expense->payment_method_id ?: 0])}}" class="text-dark">{{$expense?->payment_method?->name ?: "(blank)"}}</a></td>
                        <td data-label="Expense Date">{{ $expense->expense_date ?: "(blank)" }}</td>
                        <td data-label="Amount">{{ $expense->amount ? number_format($expense->amount) : "(blank)" }}</td>

                        <td data-label="Actions:" class="text-nowrap">
                         @if($expense->trashed())
                         <form action="{{ route('expenses.restore', ['expense' => $expense]) }}" method="POST" class="d-inline-block me-2">
                            @csrf
                            @method('PUT')
                            <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="{{ route('expenses.purge', ['expense' => $expense]) }}" method="POST" class="d-inline-block">
                            @csrf
                            @method('DELETE')
                            <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
                        </form>
                        @else
                        <a href="{{route('expenses.show', compact('expense'))}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{route('expenses.edit', compact('expense'))}}">@lang('Edit')</a></li>
                                <li>
                                    <form action="{{route('expenses.destroy', compact('expense'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="dropdown-item">@lang('Delete')</button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        @endif

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        {{-- {{ $expenses->withQueryString()->links() }} --}}
    </div>
    <div class="text-center my-2">
        <a href="{{ route('expenses.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Expense')</a>
    </div>
</div>
</div>
@endsection
