@extends('expenses.layout')

@section('expenses.content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="{{ implode('/', ['','expenses']) }}"> Expenses</a></li>
                <li class="breadcrumb-item">@lang('Edit Expense') #{{$expense->id}}</li>
            </ol>
        </div>
        <div class="card-body">
            <form action="{{ route('expenses.update', compact('expense')) }}" method="POST" class="m-0 p-0">
                @method('PUT')
                @csrf
                <div class="card-body row">
                    <div class="mb-3 col-md-6">
                        <label for="expense_item_id" class="form-label">Expense Item:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="expense_item_id" id="expense_item_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Expense Item</option>
                                @foreach($expenseItems as $expenseItem)
                                <option value="{{ $expenseItem->id }}" {{ @old('expense_item_id', $expense->expense_item_id) == $expenseItem->id ? "selected" : "" }}>{{ $expenseItem->name }}</option>
                                @endforeach
                            </select>

                            <a class="btn btn-light text-nowrap" href="{{ url('expense_items/create') }}"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        @if($errors->has('expense_item_id'))
                        <div class='error small text-danger'>{{$errors->first('expense_item_id')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="payment_method_id" class="form-label">Payment Method:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="payment_method_id" id="payment_method_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Payment Method</option>
                                @foreach($paymentMethods as $paymentMethod)
                                <option value="{{ $paymentMethod->id }}" {{ @old('payment_method_id', $expense->payment_method_id) == $paymentMethod->id ? "selected" : "" }}>{{ $paymentMethod->name }}</option>
                                @endforeach
                            </select>

                            <a class="btn btn-light text-nowrap" href="{{ url('payment_methods/create') }}"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        @if($errors->has('payment_method_id'))
                        <div class='error small text-danger'>{{$errors->first('payment_method_id')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="expense_date" class="form-label">Expense Date:</label>
                        <input type="text" name="expense_date" id="expense_date" class="form-control" value="{{@old('expense_date', $expense->expense_date)}}" required/>
                        @if($errors->has('expense_date'))
                        <div class='error small text-danger'>{{$errors->first('expense_date')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="amount" class="form-label">Amount:</label>
                        <input type="text" name="amount" id="amount" class="form-control number_format" value="{{@old('amount', $expense->amount)}}" required/>
                        @if($errors->has('amount'))
                        <div class='error small text-danger'>{{$errors->first('amount')}}</div>
                        @endif
                    </div>

                </div>
                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="{{ route('expenses.index', []) }}" class="btn btn-light">Cancel</a>
                        <button type="submit" class="btn btn-primary">@lang('Update Expense')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
