@extends('layouts.app')

@section('content')
{{-- <div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="{{ implode('/', ['','customers']) }}"> Customers</a></li>
                <li class="breadcrumb-item">@lang('Customer') #{{$customer->id}}</li>
            </ol>

            <a href="{{ route('customers.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
        </div>

        <div class="card-body">
            
        </div>

        <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
            <a href="{{ route('customers.edit', compact('customer')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
            <form action="{{ route('customers.destroy', compact('customer')) }}" method="POST" class="m-0 p-0">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
            </form>
        </div>
    </div>
</div> --}}

<div class="card">
    <div class="card-header">
        <h5>{{ $customer->name }}</h5>
    </div>
    <div class="card-body">
        <!-- Nav tabs -->
        <ul class="nav nav-pills nav-justified mb-3" role="tablist">
            <li class="nav-item waves-effect waves-light">
                <a class="nav-link active" data-bs-toggle="tab" href="#pill-justified-home-1" role="tab">
                    Overview
                </a>
            </li>
            <li class="nav-item waves-effect waves-light">
                <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-profile-1" role="tab">
                    Invoices
                </a>
            </li>
            <li class="nav-item waves-effect waves-light">
                <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-messages-1" role="tab">
                    Transactions
                </a>
            </li>
            {{-- <li class="nav-item waves-effect waves-light">
                <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-settings-1" role="tab">
                    Settings
                </a>
            </li> --}}
        </ul>
        <!-- Tab panes -->
        <div class="tab-content text-muted">
            <div class="tab-pane active" id="pill-justified-home-1" role="tabpanel">
                <table class="table table-striped">
                    <tbody>
                        <tr>
                            <th scope="row">Address:</th>
                            <td>{{ $customer->address ?: "(blank)" }}</td>
                        </tr>
                        <tr>
                            <th scope="row">Email:</th>
                            <td>{{ $customer->email ?: "(blank)" }}</td>
                        </tr>
                        <tr>
                            <th scope="row">Phone No:</th>
                            <td>{{ $customer->phone_no ?: "(blank)" }}</td>
                        </tr>
                        <tr>
                            <th scope="row">Alt Phone No:</th>
                            <td>{{ $customer->alt_phone_no ?: "(blank)" }}</td>
                        </tr>
                        <tr>
                            <th scope="row">Tin:</th>
                            <td>{{ $customer->tin ?: "(blank)" }}</td>
                        </tr>
                        <tr>
                            <th scope="row">Password:</th>
                            <td>{{ $customer->password ?: "(blank)" }}</td>
                        </tr>
                        <tr>
                            <th scope="row">Balance:</th>
                            <td>{{ number_format($customer->balance) ?: "(blank)" }}</td>
                        </tr>
                    </tbody>
                </table>

                <div class="row">
                    @foreach($customer->taxes as $tax)
                    <div class="col-md-4">
                        {{ $tax->name }}
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="tab-pane" id="pill-justified-profile-1" role="tabpanel">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered dataTable">
                        <thead role="rowgroup bg-light">
                            <tr role="row">
                                <th role='columnheader'>Invoice No</th>
                                <th role='columnheader'>Issue Date</th>
                                <th role='columnheader'>Gross Amount</th>
                                <th role='columnheader'>Sales Person</th>
                                <th role='columnheader'>Status</th>
                                <th role='columnheader'>Created By</th>
                                <th scope="col" data-label="Actions">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customer->invoices as $invoice)
                            <tr>
                                <td data-label="Invoice No">INV{{ sprintf("%05d",$invoice->invoice_no) ?: "(blank)" }}</td>
                                <td data-label="Issue Date">{{ $invoice->issue_date ?: "(blank)" }}</td>
                                <td data-label="Gross Amount">{{ number_format($invoice->gross_amount) ?: "(blank)" }}</td>
                                <td data-label="Sales Person">{{ $invoice->sales_person ?: "(blank)" }}</td>
                                <td data-label="Status">
                                    <span class="badge {{ ($invoice->status == "Completed") ? "bg-primary" : "bg-warning" }}">{{ $invoice->status ?: "(blank)" }}</span>
                                </td>
                                <td data-label="Created By">{{ $invoice->user->name ?: "(blank)" }}</td>

                                <td data-label="Actions:" class="text-nowrap">
                                 @if($invoice->trashed())
                                 <form action="{{ route('invoices.restore', ['invoice' => $invoice]) }}" method="POST" class="d-inline-block me-2">
                                    @csrf
                                    @method('PUT')
                                    <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
                                </form>
                                <form action="{{ route('invoices.purge', ['invoice' => $invoice]) }}" method="POST" class="d-inline-block">
                                    @csrf
                                    @method('DELETE')
                                    <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
                                </form>
                                @else
                                <a href="{{route('invoices.show', compact('invoice'))}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
                                @if($invoice->status == "Draft")
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="{{route('invoices.edit', compact('invoice'))}}">@lang('Edit')</a></li>
                                        <li>
                                            <form action="{{route('invoices.destroy', compact('invoice'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="dropdown-item">@lang('Delete')</button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                                @endif

                                @endif

                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane" id="pill-justified-messages-1" role="tabpanel">
            <div class="table-responsive ">
            <table class="table table-striped table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th role='columnheader'>Received By</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($customer->invoice_payments as $payment)
                        <tr>
                            <td>INV{{ sprintf("%05d",$payment->invoice->invoice_no) }}</td>
                            <td>{{ $payment->amount }}</td>
                            <td>{{ $payment->balance }}</td>
                            <td>{{ $payment->user->name }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        </div>
        <div class="tab-pane" id="pill-justified-settings-1" role="tabpanel">
            <div class="d-flex mt-2">
                <div class="flex-shrink-0">
                    <i class="ri-checkbox-circle-fill text-success"></i>
                </div>
                <div class="flex-grow-1 ms-2">
                    For that very reason, I went on a quest and spoke to many different professional graphic designers and asked them what graphic design tips they live.
                </div>
            </div>
            <div class="d-flex mt-2">
                <div class="flex-shrink-0">
                    <i class="ri-checkbox-circle-fill text-success"></i>
                </div>
                <div class="flex-grow-1 ms-2">
                    After gathering lots of different opinions and graphic design basics, I came up with a list of 30 graphic design tips that you can start implementing.
                </div>
            </div>
        </div>
    </div>
</div><!-- end card-body -->
</div>
@endsection
