@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="{{ implode('/', ['','customers']) }}"> Customers</a></li>
                <li class="breadcrumb-item">@lang('Create new')</li>
            </ol>
        </div>

        <div class="card-body">
            <form action="{{ route('customers.store', []) }}" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    @csrf
                    <div class="mb-3">
                        <label for="name" class="form-label">Name:</label>
                        <input type="text" name="name" id="name" class="form-control" value="{{@old('name')}}" required/>
                        @if($errors->has('name'))
                        <div class='error small text-danger'>{{$errors->first('name')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="address" class="form-label">Address:</label>
                        <input type="text" name="address" id="address" class="form-control" value="{{@old('address')}}" />
                        @if($errors->has('address'))
                        <div class='error small text-danger'>{{$errors->first('address')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="email" class="form-label">Email:</label>
                        <input type="email" name="email" id="email" class="form-control" value="{{@old('email')}}" />
                        @if($errors->has('email'))
                        <div class='error small text-danger'>{{$errors->first('email')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="phone_no" class="form-label">Phone No:</label>
                        <input type="text" name="phone_no" id="phone_no" class="form-control" value="{{@old('phone_no')}}" />
                        @if($errors->has('phone_no'))
                        <div class='error small text-danger'>{{$errors->first('phone_no')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="alt_phone_no" class="form-label">Alt Phone No:</label>
                        <input type="text" name="alt_phone_no" id="alt_phone_no" class="form-control" value="{{@old('alt_phone_no')}}" />
                        @if($errors->has('alt_phone_no'))
                        <div class='error small text-danger'>{{$errors->first('alt_phone_no')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-4">
                        <label for="tin" class="form-label">Tin:</label>
                        <input type="text" name="tin" id="tin" class="form-control" value="{{@old('tin')}}" />
                        @if($errors->has('tin'))
                        <div class='error small text-danger'>{{$errors->first('tin')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-4">
                        <label for="password" class="form-label">Password:</label>
                        <input type="password" name="password" id="password" class="form-control" value="{{@old('password')}}" />
                        @if($errors->has('password'))
                        <div class='error small text-danger'>{{$errors->first('password')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-4">
                        <label for="balance" class="form-label">Balance:</label>
                        <input type="number" name="balance" id="balance" class="form-control" value="{{@old('balance')}}" required/>
                        @if($errors->has('balance'))
                        <div class='error small text-danger'>{{$errors->first('balance')}}</div>
                        @endif
                    </div>
                    <div class="row">
                        @foreach($taxes as $tax)
                            <div class="form-group col-md-3">
                                <input type="checkbox" id="tax_{{ $tax->id }}" name="taxes[]" value="{{ $tax->id }}">
                                <label class="form-label" for="tax_{{ $tax->id }}">{{ $tax->name }}</label>
                            </div>
                        @endforeach
                    </div>
                    
                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="{{ route('customers.index', []) }}" class="btn btn-light">@lang('Cancel')</a>
                        <button type="submit" class="btn btn-primary">@lang('Create new Customer')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
