@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-header d-flex justify-content-between">
		<h5>Recent Analysis</h5>
		<a href="{{ url('analysis/create') }}" class="btn btn-primary">New Analysis</a>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table table-striped table dataTable">
				<thead class="table-light ">
					<th>Customer</th>
					<th>Records</th>
					<th>Progress</th>
					<th>Status</th>
					<th>Actions</th>
				</thead>
				<tbody>
					@foreach($records as $record)
					<tr>
						<td>
							{{ $record?->customer?->name }}
						</td>
						<td>
							{{ $record->total }}
						</td>
						<td>
							{{ number_format(($record->successful + $record->failed)).' of '.number_format($record->total) }}
						</td>
						<td>
							{{ ($record->total - ($record->successful + $record->failed)) > 0 ? "Ongoing" : "Complete" }}
						</td>
						<td>
							<a href="{{ url('analysis/'.$record->id) }}" class="btn btn-primary btn-sm">Show</a>
						</td>
					</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection
@section('customjs')
@endsection