<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('analysis_items', function (Blueprint $table) {
            $table->id();
            $table->integer('analysis_id');
            $table->string('type');
            $table->string('fdn');
            $table->string('standard_sales')->nullable();
            $table->string('exempted_sales')->nullable();
            $table->string('zero_rated_sales')->nullable();
            $table->string('deemed_sales')->nullable();
            $table->string('vat')->nullable();
            $table->string('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('analysis_items');
    }
};
