<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('efris_queries', function (Blueprint $table) {
            $table->id();
            $table->string('uuid');
            $table->string('fdn');
            $table->string('standard_sales')->nullable();
            $table->string('exempted_sales')->nullable();
            $table->string('zero_rated_sales')->nullable();
            $table->string('deemed_sales')->nullable();
            $table->integer('user_id');
            $table->enum('status',['Pending','Complete','Failed']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('efris_queries');
    }
};
