<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Purchase extends Model
{
    use HasFactory,softDeletes;

    /**
     * Purchase belongs to Payment_method.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payment_method()
    {
        // belongsTo(RelatedModel, foreignKey = payment_method_id, keyOnRelatedModel = id)
        return $this->belongsTo(PaymentMethod::class);
    }

    /**
     * Purchase belongs to Supplier.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function supplier()
    {
        // belongsTo(RelatedModel, foreignKey = supplier_id, keyOnRelatedModel = id)
        return $this->belongsTo(Supplier::class);
    }

    /**
     * Purchase belongs to Item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        // belongsTo(RelatedModel, foreignKey = item_id, keyOnRelatedModel = id)
        return $this->belongsTo(Item::class);
    }
}
