<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model
{
    use HasFactory,softDeletes;

    public static function getNextInvNo()
    {
        $count = Invoice::where('type','Invoice')->count();
        return sprintf('%05d',$count+1);
    }

    /**
     * Query scope invoices.
     *
     * @param  \Illuminate\Database\Eloquent\Builder
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeInvoices($query)
    {
        return $query->where('type','Invoice')
                        ->orWhere('type','Recurring Invoice')
                        ->orWhere('type','Receipt Sale');
    }

    public static function getNextQouteNo()
    {
        $count = Invoice::where('type','Quotation')->count();
        return sprintf('%05d',$count+1);
    }

    /**
     * Invoice belongs to Customer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        // belongsTo(RelatedModel, foreignKey = customer_id, keyOnRelatedModel = id)
        return $this->belongsTo(Customer::class)->withTrashed();
    }

    /**
     * Invoice belongs to User.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function User()
    {
        // belongsTo(RelatedModel, foreignKey = user_id, keyOnRelatedModel = id)
        return $this->belongsTo(User::class,'created_by');
    }

    /**
     * Invoice has many Invoice_items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function invoice_items()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = invoice_id, localKey = id)
        return $this->hasMany(InvoiceItem::class);
    }

    /**
     * Invoice belongs to Payment_method.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payment_method()
    {
        // belongsTo(RelatedModel, foreignKey = payment_method_id, keyOnRelatedModel = id)
        return $this->belongsTo(PaymentMethod::class);
    }

    public function payments()
    {
        return $this->hasMany(InvoicePayment::class,'invoice_id');
    }
}
