<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Expense extends Model
{
    use HasFactory,softDeletes;

    /**
     * Expense belongs to Payment_method.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payment_method()
    {
        // belongsTo(RelatedModel, foreignKey = payment_method_id, keyOnRelatedModel = id)
        return $this->belongsTo(PaymentMethod::class);
    }

    /**
     * Expense belongs to Expense_item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function expense_item()
    {
        // belongsTo(RelatedModel, foreignKey = expense_item_id, keyOnRelatedModel = id)
        return $this->belongsTo(ExpenseItem::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
