<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory,softDeletes;

    /**
     * Customer has many Monthly_fillings.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function monthly_fillings()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = customer_id, localKey = id)
        return $this->hasMany(MonthlyFilling::class);
    }

    public function taxes()
    {
        return $this->belongsToMany(Tax::class)->withTimestamps();
    }

    /**
     * Customer has many Invoices.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function invoices()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = customer_id, localKey = id)
        return $this->hasMany(Invoice::class)->where('type','Invoice')
                        ->orWhere('type','Recurring Invoice')
                        ->orWhere('type','Receipt Sale');
    }

    public function invoice_payments()
    {
        return $this->hasManyThrough(InvoicePayment::class, Invoice::class);
    }
}
