<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Mail\Mailables\Attachment;
use App\Models\Invoice;
use Dompdf\Dompdf;
use Dompdf\Options;

class InvoiceMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct(public Request $request,public Invoice $inv)
    {
        //
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: $this->request->subject,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        

        return new Content(
            view: 'mails.invoice',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        // $invoice = $this->inv;
        // $pdf = Pdf::loadView('sales.invoices.templates.1', compact('invoice'));
        // $filename = public_path()."/temp_attachments/".rand(200,100000).'.pdf';
        // $pdf->save($filename);

        // $invoice->invoice_name = $filename;
        // $invoice->save();

        // return [
        //     Attachment::fromPath($filename)
        //         ->as('invoice.pdf')
        //         ->withMime('application/pdf'),
        // ];

        $pdfOptions = new Options();
        $pdfOptions->set('defaultFont', 'Courier');
        $pdfOptions->set('isRemoteEnabled', true); // Enable remote file inclusion
        $dompdf = new Dompdf($pdfOptions);

        $invoice = $this->inv;
        $view = \View::make('sales.invoices.templates.1', compact('invoice'))->render();
        $dompdf->loadHtml($view);
        $dompdf->render();
        $pdfAttachment = $dompdf->output();

        return [
            Attachment::fromData(fn () => $pdfAttachment, 'invoice.pdf')
                    ->withMime('application/pdf'),
        ];
    }
}
