<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Invitation;
use Auth;
use Spatie\Permission\Models\Permission;

class UsersController extends Controller
{
    public function users()
    {
        $users = User::all();

        return view('settings.users.index',compact('users'));
    }

    public function status($user,$status)
    {
        try{
            if ($user == Auth::user()->id) {
                return redirect()->back()->with('error','You can not change your account status');
            }

            $user = User::find($user);
            $user->status = $status;
            $user->save();

            return redirect()->back()->with('success','User status has been changed to '.$status);
        }catch(\Throwable $e){
            return redirect()->back()->with('error',$e->getMessage());
        }
    }

    public function invite(Request $request)
    {
        try{
            if (User::where('email',$request->email)->first()) {
                return redirect()->back()->with('error',"Email has been used already!")->withInput();
            }

            $invitations = Invitation::where('email',$request->email)->delete();

            $invitation = new Invitation;
            $invitation->email = $request->email;
            $invitation->token = \Str::random(40);
            $invitation->save();

            \Mail::to($request->email)->send(new \App\Mail\InvitationMail($invitation));
            return redirect()->back()->with('success','Invitation has been sent!');
        }catch(\Throwable $e){
            return redirect()->back()->with('error',$e->getMessage())->withInput();
        }
    }

    public function permissions($user)
    {
        $user = User::find($user);

        return view('settings.users.permissions',compact('user'));
    }

    public function assign_permission(Request $request)
    {
        $permission = Permission::firstOrCreate(['name' => 'show invoices']);
        $permission = Permission::firstOrCreate(['name' => 'create invoices']);
        $permission = Permission::firstOrCreate(['name' => 'update invoices']);
        $permission = Permission::firstOrCreate(['name' => 'delete invoices']);
        $permission = Permission::firstOrCreate(['name' => 'overview invoices']);

        $permission = Permission::firstOrCreate(['name' => 'show quotations']);
        $permission = Permission::firstOrCreate(['name' => 'create quotations']);
        $permission = Permission::firstOrCreate(['name' => 'update quotations']);
        $permission = Permission::firstOrCreate(['name' => 'delete quotations']);
        $permission = Permission::firstOrCreate(['name' => 'overview quotations']);

        $permission = Permission::firstOrCreate(['name' => 'show payments']);
        $permission = Permission::firstOrCreate(['name' => 'create payments']);
        $permission = Permission::firstOrCreate(['name' => 'update payments']);
        $permission = Permission::firstOrCreate(['name' => 'delete payments']);
        $permission = Permission::firstOrCreate(['name' => 'overview payments']);

        $permission = Permission::firstOrCreate(['name' => 'show items']);
        $permission = Permission::firstOrCreate(['name' => 'create items']);
        $permission = Permission::firstOrCreate(['name' => 'update items']);
        $permission = Permission::firstOrCreate(['name' => 'delete items']);
        $permission = Permission::firstOrCreate(['name' => 'overview items']);

        $permission = Permission::firstOrCreate(['name' => 'show expenses']);
        $permission = Permission::firstOrCreate(['name' => 'create expenses']);
        $permission = Permission::firstOrCreate(['name' => 'update expenses']);
        $permission = Permission::firstOrCreate(['name' => 'delete expenses']);
        $permission = Permission::firstOrCreate(['name' => 'overview expenses']);

        $user = User::find($request->user);
        if ($request->assigned == "true") {
            $user->givePermissionTo($request->permission);
        }else{
            $user->revokePermissionTo($request->permission);
        }
        return $request;
    }
}
