<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Supplier;

class SupplierController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Supplier::class, 'supplier');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $suppliers = Supplier::query();

		if (!!$request->trashed) {
			$suppliers->withTrashed();
		}

        if(!empty($request->search)) {
			$suppliers->where('name', 'like', '%' . $request->search . '%');
		}

        $suppliers = $suppliers->get();

        return view('suppliers.index', compact('suppliers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('suppliers.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required", "balance" => "required"]);

        try {

            $supplier = new Supplier();
            $supplier->name = $request->name;
		$supplier->contacts = $request->contacts;
		$supplier->address = $request->address;
		$supplier->tin = $request->tin;
		$supplier->balance = $request->balance;
            $supplier->save();

            return redirect()->route('suppliers.index', [])->with('success', __('Supplier created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('suppliers.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Supplier $supplier
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Supplier $supplier,) {

        return view('suppliers.show', compact('supplier'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Supplier $supplier
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Supplier $supplier,) {

        return view('suppliers.edit', compact('supplier'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Supplier $supplier,) {

        $request->validate(["name" => "required", "balance" => "required"]);

        try {
            $supplier->name = $request->name;
		$supplier->contacts = $request->contacts;
		$supplier->address = $request->address;
		$supplier->tin = $request->tin;
		$supplier->balance = $request->balance;
            $supplier->save();

            return redirect()->route('suppliers.index', [])->with('success', __('Supplier edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('suppliers.edit', compact('supplier'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Supplier $supplier
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Supplier $supplier,) {

        try {
            $supplier->delete();

            return redirect()->route('suppliers.index', [])->with('success', __('Supplier deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('suppliers.index', [])->with('error', 'Cannot delete Supplier: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Supplier $supplier
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $supplier_id,) {

        $supplier = Supplier::withTrashed()->find($supplier_id);
        $this->authorize('delete', [Supplier::class, $supplier]);

        if (!empty($supplier)) {
            $supplier->restore();
            return redirect()->route('suppliers.index', [])->with('success', __('Supplier restored successfully'));
        } else {
            return redirect()->route('suppliers.index', [])->with('error', 'Supplier not found');
        }
    }

    public function purge( int $supplier_id,) {

        $supplier = Supplier::withTrashed()->find($supplier_id);
        $this->authorize('delete', [Supplier::class, $supplier]);

        if (!empty($supplier)) {
            $supplier->forceDelete();
            return redirect()->route('suppliers.index', [])->with('success', __('Supplier purged successfully'));
        } else {
            return redirect()->route('suppliers.index', [])->with('error', __('Supplier not found'));
        }
    }
    //@endsoftdelete
}
