<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Invoice;
use App\Models\Item;
use App\Helpers\InvoicesHelper;
use App\Models\PaymentMethod;
use Auth;
use Dompdf\Dompdf;
use Illuminate\Support\Facades\View;
use Dompdf\Options;

class QuotationsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request,)
    {
        if(!Auth::user()->can('show quotations')){
            return redirect('dashboard')->with('error',"Permission denied!");
        }
        $invoices = Invoice::query()->where('type','Quotation');

        if (!Auth::user()->can('overview quotations')) {
            $invoices->where('created_by',Auth::user()->id);
        }

        if (!!$request->trashed) {
            $invoices->withTrashed();
        }

        $invoices = $invoices->with('customer')->get();

        return view('sales.quotations.index', compact('invoices'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if(!Auth::user()->can('create quotations')){
            return redirect('dashboard')->with('error',"Permission denied!");
        }
        $customers = \App\Models\Customer::all();
        $items = Item::all();
        $invoice_no = Invoice::getNextQouteNo();
        $tcs = \App\Models\TC::first()->qoutations;

        return view('sales.quotations.create', compact('customers','items','invoice_no','tcs'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([ "customer" => "required", "due_date" => "required",]);

        try {

            if(!Auth::user()->can('create quotations')){
                return redirect('dashboard')->with('error',"Permission denied!");
            }

            $InvoicesHelper = new InvoicesHelper;
            $InvoicesHelper->saveInvoice($request,'Quotation');

            return redirect()->route('quotations.index', [])->with('success', __('Invoice created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('quotations.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $invoice = Invoice::find($id);
        return view('sales.quotations.show', compact('invoice'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function download($id)
    {
        $invoice = Invoice::find($id);
        
        $options = new Options();
        $options->set('defaultFont', 'Courier');
        $options->set('isRemoteEnabled', true);

        $dompdf = new Dompdf($options);
        $view = View::make('sales.quotations.templates.1', compact('invoice'))->render();
        $dompdf->loadHtml($view);

        // Render the HTML as PDF
        $dompdf->render();
        $dompdf->stream('Quotation-'.$id.'.pdf');
    }
}
