<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\PurchasePayment;

class PurchasePaymentController extends Controller {

    public function __construct() {
		// $this->authorizeResource(PurchasePayment::class, 'purchasePayment');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $purchasePayments = PurchasePayment::query();
		// $purchasePayments->where('user_id', auth()->id());

        if (!!$request->trashed) {
         $purchasePayments->withTrashed();
     }

     $purchasePayments->with('purchase');
     $purchasePayments->with('payment_method');

     if(!empty($request->search)) {
         $purchasePayments->where('amount', 'like', '%' . $request->search . '%');
     }

     $purchasePayments = $purchasePayments->get();

     return view('purchase_payments.index', compact('purchasePayments'));
 }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        $purchases = \App\Models\Purchase::where('balance','>',0)->get();
        $paymentMethods = \App\Models\PaymentMethod::where('type','!=','Credit')->get();

        return view('purchase_payments.create', compact('purchases', 'paymentMethods'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["purchase_id" => "required", "payment_method_id" => "required", "amount" => "required"]);

        try {

            $request->amount = str_replace(",", "", $request->amount);

            \DB::beginTransaction();
            $purchase = \App\Models\Purchase::find($request->purchase_id);

            $balance = $purchase->balance - $request->amount;

            $purchasePayment = new PurchasePayment();
            $purchasePayment->purchase_id = $request->purchase_id;
            $purchasePayment->payment_method_id = $request->payment_method_id;
            $purchasePayment->amount = $request->amount;
            $purchasePayment->balance = $balance;
            $purchasePayment->user_id = auth()->id();
            $purchasePayment->save();

            $purchase->balance = $balance;
            $purchase->save();

            $supplier = $purchase->supplier;
            $supplier->balance -= $request->amount;
            $supplier->save();

            \DB::commit();

            return redirect()->route('purchase_payments.index', [])->with('success', __('Purchase Payment created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('purchase_payments.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\PurchasePayment $purchasePayment
     *
     * @return \Illuminate\Http\Response
     */
    public function show(PurchasePayment $purchasePayment,) {

        return view('purchase_payments.show', compact('purchasePayment'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\PurchasePayment $purchasePayment
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(PurchasePayment $purchasePayment,) {

        $purchases = \App\Models\Purchase::all();
        $paymentMethods = \App\Models\PaymentMethod::all();

        return view('purchase_payments.edit', compact('purchasePayment', 'purchases', 'payment_methods'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PurchasePayment $purchasePayment,) {

        $request->validate(["purchase_id" => "required", "payment_method_id" => "required", "amount" => "required", "balance" => "required"]);

        try {
            $purchasePayment->purchase_id = $request->purchase_id;
            $purchasePayment->payment_method_id = $request->payment_method_id;
            $purchasePayment->amount = $request->amount;
            $purchasePayment->balance = $request->balance;
            $purchasePayment->save();

            return redirect()->route('purchase_payments.index', [])->with('success', __('Purchase Payment edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('purchase_payments.edit', compact('purchasePayment'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\PurchasePayment $purchasePayment
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(PurchasePayment $purchasePayment,) {

        try {
            $purchasePayment->delete();

            return redirect()->route('purchase_payments.index', [])->with('success', __('Purchase Payment deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('purchase_payments.index', [])->with('error', 'Cannot delete Purchase Payment: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\PurchasePayment $purchasePayment
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $purchasePayment_id,) {

        $purchasePayment = PurchasePayment::withTrashed()->where('user_id', auth()->id())->find($purchasePayment_id);
        $this->authorize('delete', [PurchasePayment::class, $purchasePayment]);

        if (!empty($purchasePayment)) {
            $purchasePayment->restore();
            return redirect()->route('purchase_payments.index', [])->with('success', __('Purchase Payment restored successfully'));
        } else {
            return redirect()->route('purchase_payments.index', [])->with('error', 'Purchase Payment not found');
        }
    }

    public function purge( int $purchasePayment_id,) {

        $purchasePayment = PurchasePayment::withTrashed()->where('user_id', auth()->id())->find($purchasePayment_id);
        $this->authorize('delete', [PurchasePayment::class, $purchasePayment]);

        if (!empty($purchasePayment)) {
            $purchasePayment->forceDelete();
            return redirect()->route('purchase_payments.index', [])->with('success', __('Purchase Payment purged successfully'));
        } else {
            return redirect()->route('purchase_payments.index', [])->with('error', __('Purchase Payment not found'));
        }
    }
    //@endsoftdelete
}
