<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\MonthlyFilling;
use Spatie\SimpleExcel\SimpleExcelReader;
use App\Helpers\Efris;
use App\Models\EfrisQuery;

class MonthlyFillingController extends Controller {

    public function __construct() {
		// $this->authorizeResource(MonthlyFilling::class, 'monthlyFilling');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $monthlyFillings = MonthlyFilling::query();

        $monthlyFillings->with('customer');

        if(!empty($request->search)) {
         $monthlyFillings->where('month', 'like', '%' . $request->search . '%');
     }

     $monthlyFillings = $monthlyFillings->get();

     $customers = \App\Models\Customer::withTrashed()->get();

     $users = \App\Models\User::get();

     return view('monthly_fillings.index', compact('monthlyFillings','customers','users'));
 }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        $customers = \App\Models\Customer::all();
        $users = \App\Models\User::all();

        return view('monthly_fillings.create', compact('customers', 'users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["customer_id" => "required", "month" => "required",]);

        try {

            $request->standard_sales =  str_replace(",",'',$request->standard_sales);
            $request->deemed_sales = str_replace(',','',$request->deemed_sales);
            $request->zero_rated_sales = str_replace(',','',$request->zero_rated_sales);
            $request->exempted_sales = str_replace(',','',$request->exempted_sales);
            $request->purchases = str_replace(',','',$request->purchases);
            $request->non_vat_purchases = str_replace(',','',$request->non_vat_purchases);
            $request->imports = str_replace(',','',$request->imports);

            $request->standard_sales =  ($request->standard_sales) ?: 0;
            $request->deemed_sales = ($request->deemed_sales) ?: 0;
            $request->zero_rated_sales = ($request->zero_rated_sales) ?: 0;
            $request->exempted_sales = ($request->exempted_sales) ?: 0;
            $request->purchases = ($request->purchases)?:0;
            $request->non_vat_purchases = ($request->non_vat_purchases)?:0;
            $request->imports = ($request->imports)?:0;

            $vat = ($request->standard_sales * 0.18) - (($request->purchases * 0.18) + ($request->imports * 0.18));

            $monthlyFilling = new MonthlyFilling();
            $monthlyFilling->customer_id = $request->customer_id;
            $monthlyFilling->month = $request->month;
            $monthlyFilling->standard_sales = round($request->standard_sales,2);
            $monthlyFilling->deemed_sales = round($request->deemed_sales,2);
            $monthlyFilling->zero_rated_sales = round($request->zero_rated_sales,2);
            $monthlyFilling->exempted_sales = round($request->exempted_sales,2);
            $monthlyFilling->purchases = round($request->purchases,2);
            $monthlyFilling->output_vat = round($vat,2);
            $monthlyFilling->gross_sales = round(($request->standard_sales + $request->deemed_sales + $request->zero_rated_sales + $request->exempted_sales),2);
            $monthlyFilling->net_sales = round($monthlyFilling->gross_sales - ($request->purchases + $request->non_vat_purchases + $request->imports),2);
            $monthlyFilling->non_vat_purchases = round($request->non_vat_purchases,2);
            $monthlyFilling->imports = round($request->imports,2);
            $monthlyFilling->filling_date = $request->filling_date;
            $monthlyFilling->user_id = \Auth::user()->id;
            $monthlyFilling->save();

            return redirect()->route('monthly_fillings.index', [])->with('success', __('Monthly Filling created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('monthly_fillings.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\MonthlyFilling $monthlyFilling
     *
     * @return \Illuminate\Http\Response
     */
    public function show(MonthlyFilling $monthlyFilling,) {

        return view('monthly_fillings.show', compact('monthlyFilling'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\MonthlyFilling $monthlyFilling
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(MonthlyFilling $monthlyFilling,) {

        $customers = \App\Models\Customer::all();
        $users = \App\Models\User::all();

        return view('monthly_fillings.edit', compact('monthlyFilling', 'customers', 'users'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MonthlyFilling $monthlyFilling,) {

        $request->validate(["customer_id" => "required", "month" => "required",]);

        try {
            $request->standard_sales =  str_replace(",",'',$request->standard_sales);
            $request->deemed_sales = str_replace(',','',$request->deemed_sales);
            $request->zero_rated_sales = str_replace(',','',$request->zero_rated_sales);
            $request->exempted_sales = str_replace(',','',$request->exempted_sales);
            $request->purchases = str_replace(',','',$request->purchases);
            $request->non_vat_purchases = str_replace(',','',$request->non_vat_purchases);
            $request->imports = str_replace(',','',$request->imports);

            $request->standard_sales =  ($request->standard_sales) ?: 0;
            $request->deemed_sales = ($request->deemed_sales) ?: 0;
            $request->zero_rated_sales = ($request->zero_rated_sales) ?: 0;
            $request->exempted_sales = ($request->exempted_sales) ?: 0;
            $request->purchases = ($request->purchases)?:0;
            $request->non_vat_purchases = ($request->non_vat_purchases)?:0;
            $request->imports = ($request->imports)?:0;

            $vat = ($request->standard_sales * 0.18) - (($request->purchases * 0.18) + ($request->imports * 0.18));

            $monthlyFilling->customer_id = $request->customer_id;
            $monthlyFilling->month = $request->month;
            $monthlyFilling->standard_sales = round($request->standard_sales,2);
            $monthlyFilling->deemed_sales = round($request->deemed_sales,2);
            $monthlyFilling->zero_rated_sales = round($request->zero_rated_sales,2);
            $monthlyFilling->exempted_sales = round($request->exempted_sales,2);
            $monthlyFilling->purchases = round($request->purchases,2);
            $monthlyFilling->output_vat = round($vat,2);
            $monthlyFilling->gross_sales = round(($request->standard_sales + $request->deemed_sales + $request->zero_rated_sales + $request->exempted_sales),2);
            $monthlyFilling->net_sales = round($monthlyFilling->gross_sales - ($request->purchases + $request->non_vat_purchases + $request->imports),2);
            $monthlyFilling->non_vat_purchases = round($request->non_vat_purchases,2);
            $monthlyFilling->imports = round($request->imports,2);
            $monthlyFilling->filling_date = $request->filling_date;
            $monthlyFilling->user_id = \Auth::user()->id;
            $monthlyFilling->save();

            return redirect()->route('monthly_fillings.index', [])->with('success', __('Monthly Filling edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('monthly_fillings.edit', compact('monthlyFilling'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\MonthlyFilling $monthlyFilling
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(MonthlyFilling $monthlyFilling,) {

        try {
            $monthlyFilling->delete();

            return redirect()->route('monthly_fillings.index', [])->with('success', __('Monthly Filling deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('monthly_fillings.index', [])->with('error', 'Cannot delete Monthly Filling: ' . $e->getMessage());
        }
    }

    public function loadVATFiles()
    {
        return view('filings.auto.index');
    }

    public function query_efris(Request $request)
    {
        $response = new \stdClass;
        if ($request->hasFile('purchases')) {
            $summary = new \stdClass;

            $summary->standard = 0;
            $summary->exempted = 0;
            $summary->zero_rated = 0;
            $summary->deemed = 0;
            $summary->vat = 0;
            $summary->total = 0;
            $summary->succussful =0;
            $summary->failed = 0;

            $rows = SimpleExcelReader::create($request->purchases, 'csv')
                    // ->noHeaderRow()
            ->getRows()
            ->each(function(array $row) use ($summary) {
                $fdn = $row['FDN'];

                $efris = new Efris;
                $efris = $efris->invoiceDetails($fdn);

                if ($efris->code == "00") {
                    $data = json_decode($efris->data);

                    $summary->total += 1;

                    if ($data) {
                        $summary->succussful += 1;
                        foreach ($data->taxDetails as $details) {
                            if ($details->taxCategoryCode == "01") {
                                $summary->standard += $details->netAmount;
                                $summary->vat += $details->grossAmount - $details->netAmount;
                            }elseif ($details->taxCategoryCode == "02") {
                                $summary->zero_rated += $details->netAmount;
                            }elseif ($details->taxCategoryCode == "03") {
                                $summary->exempted += $details->netAmount;
                            }elseif ($details->taxCategoryCode == "04") {
                                $summary->deemed += $details->netAmount;
                            }
                        }
                    }else{
                        $summary->failed += 1;
                    }

                }
            });
            $response->purchases = $summary;
        }

        if ($request->hasFile('sales')) {
            $summary = new \stdClass;

            $summary->standard = 0;
            $summary->exempted = 0;
            $summary->zero_rated = 0;
            $summary->deemed = 0;
            $summary->vat = 0;
            $summary->total = 0;
            $summary->succussful =0;
            $summary->failed = 0;

            $rows = SimpleExcelReader::create($request->sales, 'csv')
                    // ->noHeaderRow()
            ->getRows()
            ->each(function(array $row) use ($summary) {
                $fdn = $row['FDN'];

                $efris = new Efris;
                $efris = $efris->invoiceDetails($fdn);

                if ($efris->code == "00") {
                    $data = json_decode($efris->data);

                    $summary->total += 1;

                    if ($data) {
                        $summary->succussful += 1;
                        foreach ($data->taxDetails as $details) {
                            if ($details->taxCategoryCode == "01") {
                                $summary->standard += $details->netAmount;
                                $summary->vat += $details->grossAmount - $details->netAmount;
                            }elseif ($details->taxCategoryCode == "02") {
                                $summary->zero_rated += $details->netAmount;
                            }elseif ($details->taxCategoryCode == "03") {
                                $summary->exempted += $details->netAmount;
                            }elseif ($details->taxCategoryCode == "04") {
                                $summary->deemed += $details->netAmount;
                            }
                        }
                    }else{
                        $summary->failed += 1;
                    }

                }
            });
            $response->sales = $summary;
        }

        return view('filings.auto.index',compact('response'));
    }

    public function ajax_upload(Request $request)
    {
        $data = array();

        $validator = \Validator::make($request->all(), [
          'file' => 'required|mimes:png,jpg,jpeg,csv,txt,pdf|max:2048'
      ]);

        if ($validator->fails()) {

          $data['success'] = 0;
              $data['error'] = $validator->errors()->first('file');// Error response

          }else{
              if($request->file('file')) {
                $total = 0;
                $uuid = \Str::uuid();

                $summary = new \stdClass;
                $summary->total = 0;

                if ($request->hasFile('file')) {
                 $rows = SimpleExcelReader::create($request->file('file'), 'csv')
                    // ->noHeaderRow()
                 ->getRows()
                 ->each(function(array $row) use ($uuid,$summary) {
                    $summary->total += 1;

                    $filing = new \App\Models\EfrisQuery;
                    $filing->uuid = $uuid;
                    $filing->fdn = $row['FDN'];
                    $filing->user_id = \Auth::user()->id;
                    $filing->status = "Pending";
                    $filing->save();

                    $summary->current = $filing->id;
                });
             }

                   // Response
             $data['success'] = 1;
             $data['message'] = 'total uploaded';
             $data['total'] = $summary->total;
             $data['current'] = $summary->current;
             $data['uuid'] = $uuid;
         }else{
                   // Response
             $data['success'] = 2;
             $data['message'] = 'File not uploaded.'; 
         }
     }

     return response()->json($data);
 }

 public function analyze(Request $request)
 {
     $current = EfrisQuery::where('uuid',$request->uuid)->where('status','Pending')->first();

     $efris = new Efris;
     $efris = $efris->invoiceDetails($current->fdn);

     if ($efris->code == "00") {
        $data = json_decode($efris->data);
        $current->status = "Complete";

        if ($data) {
            foreach ($data->taxDetails as $details) {
                if ($details->taxCategoryCode == "01") {
                    $current->standard_sales += $details->netAmount;
                    // $summary->vat += $details->grossAmount - $details->netAmount;
                }elseif ($details->taxCategoryCode == "02") {
                    $current->zero_rated_sales += $details->netAmount;
                }elseif ($details->taxCategoryCode == "03") {
                    $current->exempted_sales += $details->netAmount;
                }elseif ($details->taxCategoryCode == "04") {
                    $current->deemed_sales += $details->netAmount;
                }
            }
        }else{
            $current->status = "Failed";
        }

    }

    $standard_sales = $current->standard_sales;
    $deemed_sales = $current->deemed_sales;
    $exempted_sales = $current->exempted_sales;
    $zero_rated_sales = $current->zero_rated_sales;

    $current->save();

    $current = EfrisQuery::where('uuid',$request->uuid)->where('status','Complete')->count() + 1;
    $count = EfrisQuery::where('uuid',$request->uuid)->count();


    return json_encode([
        'current'=> $current,
        'count'=>$count,
        'uuid'=>$request->uuid,
        'standard_sales' => round($standard_sales,),
        'deemed_sales' => $deemed_sales,
        'zero_rated_sales' => $zero_rated_sales,
        'exempted_sales' => round($exempted_sales,2),
    ]);
}

}
