<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\InvoicePayment;
use App\Models\Invoice;
use App\Models\PaymentMethod;
use Auth;
use Dompdf\Dompdf;
use Illuminate\Support\Facades\Mail;

class InvoicePaymentsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if(!Auth::user()->can('show payments')){
            return redirect('dashboard')->with('error',"Permission denied!");
        }
        $payments = InvoicePayment::query();

        if (!Auth::user()->can('overview payments')) {
            $payments->where('user_id',Auth::user()->id);
        }

        $payments = $payments->get();

        return view('sales.payments.index',compact('payments'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $invoices = Invoice::invoices()->where('balance','>',0)->get();
        $payment_methods = PaymentMethod::where('type','!=','Credit')->get();
        return view('sales.payments.create',compact('invoices','payment_methods'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
         if(!Auth::user()->can('create payments')){
            return redirect('dashboard')->with('error',"Permission denied!");
        }
        $request->validate([
            'invoice'=>'required',
            'amount' => 'required',
            'payment_method' => 'required'
        ]);

        try{
            $request->amount = str_replace(",", "", $request->amount);

            $invoice = Invoice::find($request->invoice);

            if ($invoice->balance < $request->amount) {
                return redirect()->back()->with('error','Paid amount can not be greater than invoice balance!');
            }

            \DB::beginTransaction();
            $payment = new InvoicePayment;
            $payment->amount = $request->amount;
            $payment->user_id= \Auth::user()->id;
            $payment->balance = $invoice->balance - $payment->amount;
            $payment->payment_method_id = $request->payment_method;
            $payment->invoice_id = $request->invoice;
            $payment->customer_id = $invoice->customer_id;
            $payment->save();

            $invoice->paid += $payment->amount;
            $invoice->balance -= $payment->amount;
            $invoice->save();

            $customer = $invoice->customer;
            $customer->balance -= $payment->amount;
            $customer->save();

            \DB::commit();
            return redirect()->back()->with('success',"Payment has been received successfully");
        }catch(\Throwable $e){
            return redirect()->back()->with('error',$e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $dompdf = new Dompdf();
    $dompdf->loadHtml('<h1>Hello, World!</h1>');
    $dompdf->render();

    // Save the PDF to a file
    $pdfPath = 'pdf/example.pdf';
    \Storage::put($pdfPath, $dompdf->output());

    // Check if the file was saved successfully
    if (\Storage::exists($pdfPath)) {
        // Send the PDF via email
        $pdfData = \Storage::get($pdfPath);

        Mail::raw('Please find the attached PDF.', function ($message) use ($pdfData) {
            $message->to('ceo@alptequg.com')
                ->subject('PDF Example')
                ->attachData($pdfData, 'example.pdf');
        });

        // Delete the temporary PDF file
        \Storage::delete($pdfPath);

        return 'PDF generated and sent to the CEO.';
    } else {
        // Log an error or return an error response
        return 'Failed to save the PDF.';
    }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
