<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Expense;

class ExpenseController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Expense::class, 'expense');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $expenses = Expense::query();

        if (!!$request->trashed) {
           $expenses->withTrashed();
       }

       if (\Auth::user()->account_type == "User") {
           $expenses->where('user_id',\Auth::user()->id);
       }

       $expenses->with('expense_item');
       $expenses->with('payment_method');

       if(!empty($request->search)) {
           $expenses->where('expense_date', 'like', '%' . $request->search . '%');
       }

       $expenses = $expenses->get();

       return view('expenses.index', compact('expenses'));
   }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        $expenseItems = \App\Models\ExpenseItem::all();
        $paymentMethods = \App\Models\PaymentMethod::where('type','!=','Credit')->get();

        return view('expenses.create', compact('expenseItems', 'paymentMethods'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["expense_item_id" => "required", "payment_method_id" => "required", "expense_date" => "required", "amount" => "required"]);

        try {

            $expense = new Expense();
            $expense->expense_item_id = $request->expense_item_id;
            $expense->payment_method_id = $request->payment_method_id;
            $expense->expense_date = $request->expense_date;
            $expense->amount = str_replace(",", "", $request->amount);
            $expense->user_id = \Auth::user()->id;
            $expense->save();

            return redirect()->route('expenses.index', [])->with('success', __('Expense created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('expenses.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Expense $expense
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Expense $expense,) {

        return view('expenses.show', compact('expense'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Expense $expense
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Expense $expense,) {

        $expenseItems = \App\Models\ExpenseItem::all();
        $paymentMethods = \App\Models\PaymentMethod::all();

        return view('expenses.edit', compact('expense', 'expenseItems', 'paymentMethods'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Expense $expense,) {

        $request->validate(["expense_item_id" => "required", "payment_method_id" => "required", "expense_date" => "required", "amount" => "required"]);

        try {
            $expense->expense_item_id = $request->expense_item_id;
            $expense->payment_method_id = $request->payment_method_id;
            $expense->expense_date = $request->expense_date;
            $expense->amount = str_replace(",", "", $request->amount);
            $expense->user_id = \Auth::user()->id;
            $expense->save();

            return redirect()->route('expenses.index', [])->with('success', __('Expense edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('expenses.edit', compact('expense'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Expense $expense
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Expense $expense,) {

        try {
            $expense->delete();

            return redirect()->route('expenses.index', [])->with('success', __('Expense deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('expenses.index', [])->with('error', 'Cannot delete Expense: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Expense $expense
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $expense_id,) {

        $expense = Expense::withTrashed()->find($expense_id);
        $this->authorize('delete', [Expense::class, $expense]);

        if (!empty($expense)) {
            $expense->restore();
            return redirect()->route('expenses.index', [])->with('success', __('Expense restored successfully'));
        } else {
            return redirect()->route('expenses.index', [])->with('error', 'Expense not found');
        }
    }

    public function purge( int $expense_id,) {

        $expense = Expense::withTrashed()->find($expense_id);
        $this->authorize('delete', [Expense::class, $expense]);

        if (!empty($expense)) {
            $expense->forceDelete();
            return redirect()->route('expenses.index', [])->with('success', __('Expense purged successfully'));
        } else {
            return redirect()->route('expenses.index', [])->with('error', __('Expense not found'));
        }
    }
    //@endsoftdelete
}
