<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Invoice;
use App\Models\Expense;
use App\Models\Purchase;
use App\Models\InvoicePayment;
use Auth;

class DashboardController extends Controller
{
    public function main(){
        $date_array = array();
        $date_count = array();

        $i = 0;
        $summary = new \stdClass;
        if (Auth::user()->account_type == "Admin") {
            while ($i < 7) {
                $today = Carbon::today();
                array_push( $date_array, (string) $today->subDays($i)->format('Y-m-d') );
                $i++;
            }

            $incomes = [];
            $expenses = [];

            if(! empty( $date_array ) ){
                foreach($date_array as $date){
                    array_push($incomes, (int) Invoice::invoices()->whereDate('created_at',$date)->sum('gross_amount'));
                    array_push($expenses,(int) Expense::whereDate('expense_date',$date)->sum('amount'));
                    // $date_count = CampaignHistory::where( 'created_at', '>', $date )->get()->count();
                }
            }    

            $summary->payments = InvoicePayment::whereMonth('created_at', date('m'))->sum('amount');
            $summary->expenses = Expense::whereMonth('expense_date', date('m'))->sum('amount');
            $summary->invoices = Invoice::invoices()->whereMonth('due_date', date('m'))->sum('gross_amount');
            $summary->purchases = Purchase::whereMonth('created_at', date('m'))->sum('amount');
        }else{
            while ($i < 7) {
                $today = Carbon::today();
                array_push( $date_array, (string) $today->subDays($i)->format('Y-m-d') );
                $i++;
            }

            $incomes = [];
            $expenses = [];

            if(! empty( $date_array ) ){
                foreach($date_array as $date){
                    array_push($incomes, 
                        (int) Invoice::invoices()->where('created_by',Auth::user()->id)->whereDate('created_at',$date)->sum('gross_amount')
                    );
                    array_push($expenses,(int) Expense::where('user_id',Auth::user()->id)->whereDate('expense_date',$date)->sum('amount'));
                    // $date_count = CampaignHistory::where( 'created_at', '>', $date )->get()->count();
                }
            }

            $summary->payments = InvoicePayment::where('user_id',Auth::user()->id)->whereMonth('created_at', date('m'))->sum('amount');
            $summary->expenses = Expense::where('user_id',Auth::user()->id)->whereMonth('expense_date', date('m'))->sum('amount');
            $summary->invoices = Invoice::where('created_by',Auth::user()->id)->invoices()->whereMonth('due_date', date('m'))->sum('gross_amount');
            $summary->purchases = Purchase::where('user_id',Auth::user()->id)->whereMonth('created_at', date('m'))->sum('amount');
        }
        


       return view('dashboard',compact('incomes','expenses','date_array','summary'));
    }
}
