<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Customer;
use App\Models\Tax;

class CustomerController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Customer::class, 'customer');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $customers = Customer::query();

        if (!!$request->trashed) {
         $customers->withTrashed();
     }

     if(!empty($request->search)) {
         $customers->where('name', 'like', '%' . $request->search . '%');
     }

     $customers = $customers->get();

     return view('customers.index', compact('customers'));
 }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        $taxes = Tax::all();
        return view('customers.create', compact('taxes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required", "balance" => "required"]);

        try {

            $customer = new Customer();
            $customer->name = $request->name;
            $customer->address = $request->address;
            $customer->email = $request->email;
            $customer->phone_no = $request->phone_no;
            $customer->alt_phone_no = $request->alt_phone_no;
            $customer->tin = $request->tin;
            $customer->password = $request->password;
            $customer->balance = $request->balance;
            $customer->save();

            $customer->taxes()->sync($request->taxes);

            return redirect()->route('customers.index', [])->with('success', __('Customer created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('customers.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Customer $customer
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Customer $customer,) {

        return view('customers.show', compact('customer'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Customer $customer
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Customer $customer,) {

        $taxes = Tax::all();

        $customer_taxes = []; 

        foreach ($customer->taxes as $tax) {
            array_push($customer_taxes, $tax->id);
        }

        return view('customers.edit', compact('customer','customer_taxes','taxes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Customer $customer,) {

        $request->validate(["name" => "required"]);

        try {
            $customer->name = $request->name;
            $customer->address = $request->address;
            $customer->email = $request->email;
            $customer->phone_no = $request->phone_no;
            $customer->alt_phone_no = $request->alt_phone_no;
            $customer->tin = $request->tin;
            $customer->password = $request->password;
            // $customer->balance = $request->balance;
            $customer->save();

            $customer->taxes()->sync($request->taxes);

            return redirect()->route('customers.index', [])->with('success', __('Customer edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('customers.edit', compact('customer'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Customer $customer
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Customer $customer,) {

        try {
            $customer->delete();

            return redirect()->route('customers.index', [])->with('success', __('Customer deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('customers.index', [])->with('error', 'Cannot delete Customer: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Customer $customer
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $customer_id,) {

        $customer = Customer::withTrashed()->find($customer_id);
        // $this->authorize('delete', [Customer::class, $customer]);

        if (!empty($customer)) {
            $customer->restore();
            return redirect()->route('customers.index', [])->with('success', __('Customer restored successfully'));
        } else {
            return redirect()->route('customers.index', [])->with('error', 'Customer not found');
        }
    }

    public function purge( int $customer_id,) {

        $customer = Customer::withTrashed()->find($customer_id);
        $this->authorize('delete', [Customer::class, $customer]);

        if (!empty($customer)) {
            $customer->forceDelete();
            return redirect()->route('customers.index', [])->with('success', __('Customer purged successfully'));
        } else {
            return redirect()->route('customers.index', [])->with('error', __('Customer not found'));
        }
    }
    //@endsoftdelete
}
