<?php
namespace App\Helpers;

use Illuminate\Http\Request;
use App\Models\Invoice;
use App\Models\InvoiceItem;
use App\Models\InvoicePayment;

class InvoicesHelper{

	public function saveInvoice(Request $request,String $type)
	{
		\DB::beginTransaction();
		$invoice = new Invoice;
		$invoice->invoice_id = $request->invoice_id;
		$invoice->type = $type;
		$invoice->project_id = $request->project_id;
		if ($type == "Invoice") {
			$invoice->invoice_no = Invoice::getNextInvNo();
		}elseif($type == "Quotation"){
			$invoice->invoice_no = Invoice::getNextQouteNo();
		}
		
		$invoice->customer_id = $request->customer;
		$invoice->issue_date = date("Y-m-d");
		$invoice->subject = $request->subject;
		$invoice->reference = $request->reference;
		$invoice->due_date = $request->due_date;
		$invoice->send_date = $request->send_date;
		$invoice->ref_number = $request->ref_number;
		$invoice->next_invoicing_date = $request->next_invoicing_date;
		$invoice->paid = $request->paid;
		$invoice->balance = $request->balance;
		$invoice->net_amount = $request->net_amount;
		$invoice->vat = $request->vat;
		$invoice->gross_amount = $request->gross_amount;
		$invoice->sales_person = $request->sales_person;
		$invoice->customer_notes = $request->customer_notes;
		$invoice->t_c = $request->t_c;
		$invoice->payment_method_id = $request->payment_method;
		$invoice->status = $request->action;
		$invoice->created_by = \Auth::user()->id;
		$invoice->save();

		$gross_amount = 0;

		foreach ($request->items as $item) {
			if (gettype($item) == "array") {
				$item = json_encode($item);
			}

			$item = json_decode($item);

			$invoice_item = new InvoiceItem;
			$invoice_item->invoice_id = $invoice->id;
			$invoice_item->item_id = $item->item;
			$invoice_item->unit_price = $item->unit_price;
			$invoice_item->quantity = $item->quantity;
			$invoice_item->description = $item->description;
			$invoice_item->total = $item->quantity * $item->unit_price;
			$invoice_item->save();

			$gross_amount += $invoice_item->total;
		}

		$invoice->gross_amount = $gross_amount;
		$invoice->balance = $gross_amount;
		$invoice->paid = 0;
		$invoice->save();

		if($request->action == "Completed")
		{
			if ($type == "Invoice" || $type == "Receipt Sale") {
				$customer = $invoice->customer;
				$customer->balance += $gross_amount;
				$customer->save();

				if ($invoice->payment_method->type != "Credit") {
					$invoice->balance = 0;
					$invoice->paid = $gross_amount;
					$invoice->save();

					$payment = new InvoicePayment;
					$payment->invoice_id = $invoice->id;
					$payment->payment_method_id = $invoice->payment_method_id;
					$payment->amount = $gross_amount;
					$payment->balance = 0;
					$payment->customer_id = $invoice->customer_id;
					$payment->user_id = \Auth::user()->id;
					$payment->save();

					$customer->balance -= $gross_amount;
					$customer->save();
				}
			}
		}
		
		\DB::commit();

		return $invoice;
	}

	public function editInvoice(Request $request,Invoice $invoice,String $type)
	{

		\DB::beginTransaction();
		$invoice->project_id = $request->project_id;
		$invoice->customer_id = $request->customer;
		$invoice->subject = $request->subject;
		$invoice->reference = $request->reference;
		$invoice->due_date = $request->due_date;
		$invoice->send_date = $request->send_date;
		$invoice->ref_number = $request->ref_number;
		$invoice->next_invoicing_date = $request->next_invoicing_date;
		$invoice->paid = $request->paid;
		$invoice->balance = $request->balance;
		$invoice->net_amount = $request->net_amount;
		$invoice->vat = $request->vat;
		$invoice->gross_amount = $request->gross_amount;
		$invoice->sales_person = $request->sales_person;
		$invoice->customer_notes = $request->customer_notes;
		$invoice->t_c = $request->t_c;
		$invoice->payment_method_id = $request->payment_method;
		$invoice->status = "Completed";
		$invoice->created_by = \Auth::user()->id;
		$invoice->save();

		$gross_amount = 0;

		InvoiceItem::where('invoice_id',$invoice->id)->delete();

		foreach ($request->items as $item) {
			if (gettype($item) == "array") {
				$item = json_encode($item);
			}

			$item = json_decode($item);

			$invoice_item = new InvoiceItem;
			$invoice_item->invoice_id = $invoice->id;
			$invoice_item->item_id = $item->item;
			$invoice_item->unit_price = $item->unit_price;
			$invoice_item->quantity = $item->quantity;
			$invoice_item->description = $item->description;
			$invoice_item->total = $item->quantity * $item->unit_price;
			$invoice_item->save();

			$gross_amount += $invoice_item->total;
		}

		$invoice->gross_amount = $gross_amount;
		$invoice->save();

		\DB::commit();
	}

	private function saveInvoiceItems($type){
		return "dddxx";
	}
}