<?php
namespace App\Helpers;
date_default_timezone_set("Africa/Kampala");

class Efris 
{
	// private $tin = "1014611612",
	// $legalName = "ALPTEQ ICT SOLUTIONS LTD",
	// $businessName = "ALPTEQ ICT SOLUTIONS LTD",
	// $address = "Masaka Road",
	// $mobilePhone = "2560778497936",
	// $emailAddress = "musisifred7@gmail.com",
	// $url = 'http://127.0.0.1:9880/efristcs/ws/tcsapp/getInformation',
	// $deviceNo = "TCSf819613741270733";

 	// private $tin = "1011963636",
	// $legalName = "Mr. FREDRICK SSEMITEGO MUSISI",
	// $businessName = "Mr. FREDRICK SSEMITEGO MUSISI",
	// $address = "BUSIMBI",
	// $mobilePhone = "256753391460",
	// $emailAddress = "musisifred7@gmail.com",
	// $url = 'https://efristest.ura.go.ug/efrisws/ws/tcsapp/getInformation',
	// $deviceNo = "1011963636_1";

	// private $tin = "1014615388",
	// $legalName = "CAFFE' ROMA L'ORIGINALE LIMITED",
	// $businessName = "CAFFE' ROMA L'ORIGINALE LIMITED",
	// $address = "MAKINDYE DIVISION EAST",
	// $mobilePhone = "2560778497936",
	// $emailAddress = "musisifred7@gmail.com",
	// $url = 'http://192.168.1.145:9880/efristcs/ws/tcsapp/getInformation',
	// $deviceNo = "1014615388";

	// private $tin = "1006884029",
	// $legalName = "Nican Resort Limited",
	// $businessName = "Nican Resort Limited",
	// $address = "MAKINDYE DIVISION EAST",
	// $mobilePhone = "2560778497936",
	// $emailAddress = "musisifred7@gmail.com",
	// $url = 'https://efristest.ura.go.ug/efrisws/ws/taapp/getInformation',
	// $deviceNo = "1006884029_01";

	private $business;

	private 
	$tin,$legalName,$businessName,$address,$mobilePhone,$emailAddress,$url,$deviceNo,$appId,$private_key,$passpharse,$mode;
	// $legalName = "Nican Resort Limited",
	// $businessName = "Nican Resort Limited",
	// $address = "MAKINDYE DIVISION EAST",
	// $mobilePhone = "2560778497936",
	// $emailAddress = "musisifred7@gmail.com",
	// $url = 'http://192.168.1.34:9880/efristcs/ws/tcsapp/getInformation',
	// $deviceNo = "TCS77abca3603145095";

	function __construct()
	{
		$this->business = \Auth::user()->business;
		$this->tin = "1015448135";
		$this->legalName = "Warmth Group LTD";
		$this->businessName = "Warmth Group LTD";
		$this->address = "Ben Kiwanuka Street";
		$this->mobilePhone = "078676666";
		$this->emailAddress = "078676666";
		$this->deviceNo = "1015448135_01";
		$this->url = "https://efrisws.ura.go.ug/ws/taapp/getInformation";
		$this->passpharse = "1234567890";
		$this->private_key = "1691495418330.p12";
		$this->mode = "Online";

		if ($this->mode == "Online") {
			$this->appId = "AP04";
		}else{
			$this->appId = "AP01";
		}
	}

	public function serverTime()
	{
		return $this->request("T101");
	}

	public function getTinDetails($tin='')
	{
		// return $this->getPrivKey();
		$content = [
			"tin" => $tin,
		];

		return $this->request("T119",$content);
	}

	public function stock($items)
	{
		$request = [
			"goodsCode"=> $items,
		];

		return $this->request("T144",$request);
	}

	public function credit_notes($type=1)
	{
		$credit_notes = [
			"queryType" => $type,
			"pageNo" => "0",
			"pageSize" => "99"
		];

		return $this->request('T111',$credit_notes);
	}

	public function invoiceDetails($invoiceNo='')
	{
		$invoice = [
			"invoiceNo" => $invoiceNo,
		];

		return $this->request("T108",$invoice);
	}

	public function creditNoteApplication($credit_note)
	{
		$goodsDetails = [];
		$buyerDetails = [];
		$taxDetails =[];

		$total_vat = 0;
		$total_net = 0;
		$total_gross = 0; 
		$item_count = 0;

		foreach($credit_note->credit_note_items as $item)
		{
			$item_net = $item->net_amount;

			$item_vat = $item->vat;
			$item_gross = $item->amount;

			$total_vat += $item_vat;
			$total_net += $item_net;
			$total_gross +=$item_gross; 

			$invoice_item = [
				"itemCode" => \Auth::user()->business_id.'_'.$item->pos_item_id,
				"qty" => $item->quantity * -1,
				"unitPrice" => $item->unit_price,
				"total" => $item->amount * -1,
				"totalPrice" => $item->amount,
				"taxRate" => $item->vat_rate,
				"tax" => $item_vat * -1,
				"orderNumber" => $item_count, 
				"unitOfMeasure" => $item->pos_item->uom->external_value,
				"item" => $item->pos_item->name,
				"discountFlag" => "2",
				"discountTotal" => "",
				"discountTaxRate" => "",
				"exciseRate" => "",
				"exciseTax" => "",
				"exciseUnit" => "",
				"exciseCurrency" => "",
				// "exciseRateName" => "standard",
				"deemedFlag" => "2",
				"goodsCategoryId" => $item->pos_item->efris_category->commodityCategoryCode,
				"exciseFlag" => "2",
				"pack" => "",
				"stick" => ""
			];


			$tax = [
				"taxCategoryCode" => "01",
				"netAmount" => $item_net * -1,
				"taxRate" => "0.18",
				"taxAmount" => $item_vat * -1,
				"grossAmount" => $item_gross * -1,
				"exciseUnit" => "101",
				"exciseCurrency" => "UGX",
				"taxRateName" => "VAT(18%)"
			];

			array_push($taxDetails,$tax);

			array_push($goodsDetails, $invoice_item);
			$item_count += 1;
		}

		$summary = [
			"netAmount" => round($total_net,2) * -1,
			"taxAmount" => round($total_vat,2) * -1,
			"grossAmount" => round($total_gross,2)  * -1,
			"itemCount" => $item_count,
			"modeCode" => "0",
			"qrCode" => "asdfghjkl"
		];

		$payWay = [
			[
				"paymentMode" => "101",
				"paymentAmount" => $total_gross * -1,
				"orderNumber" => $credit_note->id
			]
		];

		$extend = [
			"reason" => "reason",
			"reasonCode" => "102"
		];

		$basicInformation = [
			"issuedDate" => date('Y-m-d'),
			"operator" => ucwords(\Auth::user()->name),
			"currency" => "UGX",
			"oriInvoiceId" => $credit_note->invoice->invoiceid,
			"invoiceType" => "1",
			"invoiceKind" => $this->business->efris_setting->fiscal_doc_type,
			"dataSource" => "101",
			"invoiceIndustryCode" => "101",
			"isBatch" => "0"
		];

		$buyerDetails = [
			"buyerTin" => $credit_note->invoice->customer->tin,
			"buyerNinBrn" => "",
			"buyerPassportNum" => "",
			"buyerLegalName" => $credit_note->invoice->customer->name,
			"buyerBusinessName" => "lisi",
			"buyerAddress" => $credit_note->invoice->customer->address,
			"buyerEmail" => "",
			"buyerMobilePhone" => "",
			"buyerLinePhone" => "",
			"buyerPlaceOfBusi" => $credit_note->invoice->customer->address,
			"buyerType" => ($credit_note->invoice->customer->type == "Individual") ? "1" : "0",
			"buyerCitizenship" => "1",
			"buyerSector" => "1",
			"buyerReferenceNo" => $credit_note->invoice->invoice_no
		];

		$importServiceSeller = [];
		$airlineGoodsDetails = [];
		$credit_note = [
			"oriInvoiceId" => $credit_note->invoice->invoiceid,
			"oriInvoiceNo" => $credit_note->invoice->fdn,
			"reasonCode" => $credit_note->reasonCode,
			"reason" => $credit_note->reason,
			"applicationTime" => date("Y-m-d H:m:s"),
			"invoiceApplyCategoryCode" => "101",
			"currency" => "UGX",
			// "contactName" => "",
			// "contactMobileNum" => "1",
			// "contactEmail" => "1",
			"source" => "101",
			"remarks" => "Remarks",
			"sellersReferenceNo" => "CN_".$credit_note->id,
			"goodsDetails" => $goodsDetails,
			"taxDetails" => $taxDetails,
			"summary" => $summary,
			"payWay" => $payWay,
			"buyerDetails" => $buyerDetails,
			"basicInformation" => $basicInformation
		];

		return $this->request("T110",$credit_note);
		
	}

	public function exchangeRate()
	{
		$content = [
			'currency' => "USD"
		];

		return $this->request("T126");
	}

	public function queryInvoices($query)
	{
		// $content = [
		// 	// "oriInvoiceNo" => "",
		// 	// "invoiceNo" => $query->invoiceNo,
		// 	// "deviceNo" => "",
		// 	// "buyerTin" => "",
		// 	// "buyerNinBrn" => "",
		// 	// "buyerLegalName" => "",
		// 	// "combineKeywords" => "",
		// 	// "invoiceType" => "",
		// 	// "invoiceKind" => $query->documentType,
		// 	"invoiceKind" => 1,
		// 	"queryType" => 0,
		// 	// "isInvalid" => "",
		// 	// "isRefund" => "",
		// 	"startDate" => "2023-03-01",
		// 	"endDate" => "2023-06-06",
		// 	"pageNo" => 1,
		// 	"pageSize" => 99,
		// 	// "referenceNo" => "",
		// 	// "branchName" => ""
		// ];

		$content = [
			// "oriInvoiceNo" => "",
			"invoiceNo" => $query->invoiceNo,
			// "deviceNo" => "",
			// "buyerTin" => "",
			// "buyerNinBrn" => "",
			// "buyerLegalName" => "",
			// "combineKeywords" => "",
			"invoiceType" => $query->documentType,
			"invoiceKind" => $query->documentKind,
			// "isInvalid" => "1",
			// "isRefund" => "1",
			"startDate" => $query->startDate,
			"endDate" => $query->endDate,
			"pageNo" => "1",
			"pageSize" => "10",
			// "referenceNo" => "",
			// "branchName" => "",
			"queryType" => $query->transactionType,
			// "dataSource" => ""
		];

		// return $content;

		return $this->request('T106',$content);
	}

	public function generalStockInquiry()
	{
		$content = [
			"goodsCode" => "",
			"goodsName " => "",
			"commodityCategoryName" => "",
			"pageNo" => "10",
			"pageSize" => "10",
			"branchId" => "",
			"serviceMark" => "",
			"haveExciseTax" => "",
			"startDate" => "",
			"endDate" =>"",
			"combineKeywords" => "",
			"goodsTypeCode" => ""
		];

		return $this->request("T127",$content);
	}

	public function stockOut($sale='')
	{
		$goodsDetails = [];

		foreach($sale->invoice_items as $good){
			$item = [
				// "commodityGoodsId" => "10426022",
				"goodsCode" => $good->pos_item->efris_item_code,
				"measureUnit" => $good->pos_item->uom->external_value,
				"quantity" => $good->qty,
				"unitPrice" => $good->unit_price
			];

			array_push($goodsDetails, $item);
		}
		$content =[
			"goodsStockIn" => [
				"operationType" => "102",
				"supplierTin" => "",
				"supplierName" => "",
				"adjustType" => "101",
				"remarks" => "",
				"stockInDate" => "",
				"stockInType" => "",
				"productionBatchNo" => "",
				"productionDate" => "",
				"branchId" => "",
				"invoiceNo" => "",
				"isCheckBatchNo" => ""
			],
			"goodsStockInItem" => $goodsDetails,
		];

		$this->request("T131",$content);
	}

	public function getEfrisGoods($value='')
	{
		$content = [
			"pageNo" => "1",
			"pageSize" => "20"
		];
		return $this->request("T107",$content);
	}

	public function getGoodDetails($itemCode)
	{
		$content = [
			"goodsCode" => $itemCode
		];
		return $this->request("T127",$content);
	}

	public function stockWriteOff($stock)
	{
		$goodsDetails = [];

		$items = \App\Models\PosItem::where('id',$stock->pos_item_id)->get();

		$item_details = \App\Models\PosItem::find($stock->pos_item_id);

			$item = [
				// "commodityGoodsId" => "10426022",
				"goodsCode" => $item_details->efris_item_code,
				"measureUnit" => $item_details->uom->external_value,
				"quantity" => $stock->quantity,
				"unitPrice" => $item_details->selling_price
			];

			array_push($goodsDetails, $item);

		$content =[
			"goodsStockIn" => [
				"operationType" => "102",
				"supplierTin" => "",
				"supplierName" => "",
				"adjustType" => $stock->type,
				"remarks" => $stock->details,
				"stockInDate" => "",
				"stockInType" => "",
				"productionBatchNo" => "",
				"productionDate" => "",
				"branchId" => "",
				"invoiceNo" => "",
				"isCheckBatchNo" => ""
			],
			"goodsStockInItem" => $goodsDetails,
		];

		return $this->request("T131",$content);
	}

	public function commodityCategoryUpdate()
	{
		$pageCount = 151;

		ini_set('max_execution_time', '0');

		return $this->request("T124",["pageNo" => "1","pageSize" => "1000"]);

		for ($i=153; $i <= 159; $i++) { 
			$content = [
				"pageNo" => $i,
				"pageSize" => "1000"
			];
			$response = $this->request("T124",$content);

			if ($response->code == "00") {
				$response->data = json_decode(gzdecode($response->data, false));
			}

			$categories = [];

			foreach($response->data->records as $record)
			{
				$category = [
					"commodityCategoryCode" => isset($record->commodityCategoryCode)? $record->commodityCategoryCode : null,
					"commodityCategoryLevel" => isset($record->commodityCategoryLevel)? $record->commodityCategoryLevel : null,
					"commodityCategoryName" => isset($record->commodityCategoryName)? $record->commodityCategoryName : null,
					"enableStatusCode" => isset($record->enableStatusCode)? $record->enableStatusCode : null,
					"exclusion" => isset($record->exclusion)? $record->exclusion : null,
					"exemptRateStartDate" => isset($record->exemptRateStartDate)? $record->exemptRateStartDate : null,
					"isExempt" => isset($record->isExempt)? $record->isExempt: null,
					"isLeafNode" => isset($record->isLeafNode)? $record->isLeafNode : null,
					"isZeroRate" => isset($record->isZeroRate)? $record->isZeroRate : null,
					"parentCode" => isset($record->parentCode)? $record->parentCode : null,
					"rate" => isset($record->rate)?$record->rate : null,
					"serviceMark" => isset($record->serviceMark)? $record->serviceMark: null
				];

				array_push($categories, $category);
				// \App\Models\EfrisCategory::updateOrCreate(
				// 	[
				// 		"commodityCategoryCode" => isset($record->commodityCategoryCode)? $record->commodityCategoryCode : null,
				// 		"commodityCategoryLevel" => isset($record->commodityCategoryLevel)? $record->commodityCategoryLevel : null,
				// 		"commodityCategoryName" => isset($record->commodityCategoryName)? $record->commodityCategoryName : null,
				// 		"enableStatusCode" => isset($record->enableStatusCode)? $record->enableStatusCode : null,
				// 		"exclusion" => isset($record->exclusion)? $record->exclusion : null,
				// 		"exemptRateStartDate" => isset($record->exemptRateStartDate)? $record->exemptRateStartDate : null,
				// 		"isExempt" => isset($record->isExempt)? $record->isExempt: null,
				// 		"isLeafNode" => isset($record->isLeafNode)? $record->isLeafNode : null,
				// 		"isZeroRate" => isset($record->isZeroRate)? $record->isZeroRate : null,
				// 		"parentCode" => isset($record->parentCode)? $record->parentCode : null,
				// 		"rate" => isset($record->rate)?$record->rate : null,
				// 		"serviceMark" => isset($record->serviceMark)? $record->serviceMark: null
				// 	],
				// 	['commodityCategoryCode' => $record->commodityCategoryCode]
				// );
			}		
			//$pageCount = $response->data->page->pageCount;

			\App\Models\EfrisCategory::insertOrIgnore($categories);

			$response->data = $pageCount." pages have been updated";
		}
		return $response;
	}

	public function invoiceUpload($sale)
	{

		$sellerDetails = [
			"tin" => $this->tin,
			"ninBrn" => "",
			"legalName" => $this->legalName,
			"businessName" => $this->businessName,
			"address" => $this->address,
			"mobilePhone" => $this->mobilePhone,
			"linePhone" => $this->mobilePhone,
			"emailAddress" => $this->emailAddress,
			"placeOfBusiness" => $this->address,
			"referenceNo" => $this->business->id."_".$sale->id,
			"branchId" => "",
			"isCheckReferenceNo" => "0"
		];

		$basicInformation = [
			"invoiceNo" => "",
			"antifakeCode" => "",
			"deviceNo" => $this->deviceNo,
			"issuedDate" => date('Y-m-d'),
			"operator" => \Auth::user()->name,
			"currency" => "UGX",
			"oriInvoiceId" => "",
			"invoiceType" => "1",
			"invoiceKind" => $this->business->efris_setting->fiscal_doc_type,
			"dataSource" => "101",
			"invoiceIndustryCode" => "101",
			"isBatch" => ""
		];

		$buyerDetails = [
			"buyerTin" => $sale->customer->tin,
			"buyerNinBrn" => "",
			"buyerPassportNum" => "",
			"buyerLegalName" => $sale->customer->name,
			"buyerBusinessName" => "lisi",
			"buyerAddress" => $sale->customer->address,
			"buyerEmail" => "",
			"buyerMobilePhone" => "",
			"buyerLinePhone" => "",
			"buyerPlaceOfBusi" => $sale->customer->address,
			"buyerType" => ($sale->customer->type == "Individual") ? "1" : "0",
			"buyerCitizenship" => "1",
			"buyerSector" => "1",
			"buyerReferenceNo" => $sale->invoice_no
		];

		$buyerExtend = [
			"propertyType" => "abc",
			"district" => "haidian",
			"municipalityCounty" => "",
			"divisionSubcounty" => "",
			"town" => "",
			"cellVillage" => "",
			"effectiveRegistrationDate" => "",
			"meterStatus" => "101"
		];

		$goodsDetails = [];
		$taxDetails = [];

		$total_net = 0;
		$total_vat = 0;
		$total_gross = 0;
		$item_count = 0;
		$orderNumber = 0;


		foreach($sale->invoice_items as $item)
		{
			$item_net = $item->net_amount;

			$item_vat = $item->vat;
			$item_gross = $item->amount;

			if ($item->pos_item->efris_category->isExempt == "101") {
				$taxCategoryCode = "03";
				$netAmount = $item_gross;
				$taxAmount = 0;
				$taxRate = "-";
				$grossAmount = $item_gross;

				$item_vat = 0;
				$item_net = $item_gross;

			}else{
				$taxCategoryCode = "01";
				$netAmount = $item_net;
				$taxAmount = $item_vat;
				$taxRate = $item->pos_item->efris_category->rate;
				$grossAmount = $item_gross;
			}

			$invoice_item = [
				"itemCode" => $item->pos_item->efris_item_code,
				"qty" => $item->quantity,
				"unitPrice" => $item->unit_price,
				"total" => $item->grand_total,
				// "totalPrice" => $item->amount,
				"taxRate" => $taxRate,
				"tax" => ($taxRate == '-') ? '0' : round($item->grand_total - ($item->grand_total / (1+ $taxRate)),2),
				"orderNumber" => $orderNumber, 
				"unitOfMeasure" => $item->pos_item->uom->external_value,
				"item" => $item->pos_item->name,
				"discountFlag" => ($item->discount > 0) ? 1 : 2,
				"discountTotal" => ($item->discount > 0) ? $item->discount * -1 : "",
				"discountTaxRate" => "",
				"exciseRate" => "",
				"exciseTax" => "",
				"exciseUnit" => "",
				"exciseCurrency" => "",
				"exciseRateName" => "standard",
				"deemedFlag" => "2",
				"goodsCategoryId" => $item->pos_item->efris_category->commodityCategoryCode,
				"exciseFlag" => "2",
				"pack" => "",
				"stick" => ""
			];


			array_push($goodsDetails, $invoice_item);
			$item_count += 1;
			$orderNumber += 1;

			if ($item->discount > 0) {
				$invoice_item = [
					"itemCode" => $item->pos_item->efris_item_code,
					"qty" => "",
					"unitPrice" => "",
					"total" => $item->discount * -1,
					// "totalPrice" => $item->discount * -1,
					"taxRate" => $taxRate,
					"tax" => round(($item->discount - round($item->discount / (1+$taxRate),2)) * -1,2),
					"orderNumber" => $orderNumber, 
					"unitOfMeasure" => $item->pos_item->uom->external_value,
					"item" => $item->pos_item->name." (Discount)",
					"discountFlag" => 0,
					"discountTotal" => "",
					"discountTaxRate" => "",
					"exciseRate" => "",
					"exciseTax" => "",
					"exciseUnit" => "",
					"exciseCurrency" => "",
					"exciseRateName" => "standard",
					"deemedFlag" => "2",
					"goodsCategoryId" => $item->pos_item->efris_category->commodityCategoryCode,
					"exciseFlag" => "2",
					"pack" => "",
					"stick" => ""
				];

				array_push($goodsDetails, $invoice_item);
				$orderNumber += 1;
			}

			$total_vat += $item_vat;
			$total_net += $item_net;
			$total_gross +=$item_gross; 

			$tax = [
				"taxCategoryCode" => $taxCategoryCode,
				"netAmount" => $netAmount,
				"taxRate" => $taxRate,
				"taxAmount" => $taxAmount,
				"grossAmount" => $grossAmount,
				"exciseUnit" => "101",
				"exciseCurrency" => "UGX",
				"taxRateName" => "VAT(18%)"
			];

			array_push($taxDetails,$tax);
		}
		
		$summary = [
			"netAmount" => round($total_net,2),
			"taxAmount" => round($total_vat,2),
			"grossAmount" => round($total_gross,2),
			"itemCount" => $item_count,
			"modeCode" => "0",
			"qrCode" => ""
		];

		if ($sale->payment_method->category == "Cash") {
			$paymentMode = "102";
		}elseif ($sale->payment_method->category == "Credit") {
			$paymentMode = "101";
		}else{
			$paymentMode = "106";
		}

		$payWay = [
			[
				"paymentMode" => $paymentMode,
				"paymentAmount" => $total_gross,
				"orderNumber" => $sale->id
			]
		];

		$extend = [
			"reason" => "reason",
			"reasonCode" => "102"
		];

		$importServiceSeller = [];
		$airlineGoodsDetails = [];

		$content = [
			"sellerDetails" => $sellerDetails,
			"basicInformation" => $basicInformation,
			"buyerDetails" => $buyerDetails,
			"buyerExtend" => $buyerExtend,
			"goodsDetails" => $goodsDetails,
			"taxDetails" => $taxDetails,
			"summary" => $summary,
			"payWay" => $payWay,
			"extend" => $extend,
			// "importServiceSeller" => $importServiceSeller,
			// "airlineGoodsDetails" => $airlineGoodsDetails
		];

		// return $content;

		// dd($content);

		$response = $this->request("T109",$content);
		// dd($response);
		return $response;
	}

	public function stockIn($purchase,$purchase_items = '')
	{
		$items = [];

		if ($purchase_items == '') {
			$purchase_items = $purchase->purchase_items;
		}

		foreach ($purchase->purchase_items as $item) {

			if (!isset($item->pos_item->efris_category->commodityCategoryCode)) {
				$res = new \stdClass;
				$res->code = "999";
				$res->message = 'Item ('.$item->pos_item->name.') not well configured!';
				return $res;
			}
			$item = [
				"goodsCode" => $item->pos_item->efris_item_code,
				"measureUnit" => $item->pos_item->uom->external_value,
				"quantity" => $item->qty,
				"unitPrice" => $item->unit_price
			];
			array_push($items,$item);
		}

		$content = [
			"goodsStockIn" => [
				"operationType" => "101",
				// "supplierTin" => $purchase->supplier->tin,
				"supplierName" => $purchase->supplier->name,
				"adjustType" => "",
				"remarks" => "gf",
				"stockInType" => "102",
				// "productionBatchNo" => "",
				// "productionDate" => "",
				// "branchId" => "",
				// "invoiceNo" => "",
				// "isCheckBatchNo" => ""
			],
			"goodsStockInItem" => $items
		];
		// return $content;

		return $this->request("T131",$content);
	}

	public function goodsUpload($item)
	{
		$item = [
			"operationType" => "101",
			"goodsName" => $item->name,
			"goodsCode" => $item->efris_item_code,
			"measureUnit"=> $item->uom->external_value,
			"unitPrice" => $item->selling_price,
			"currency"=> "101",
			"commodityCategoryId"=> $item->efris_category->commodityCategoryCode,
			"haveExciseTax"=> "102",
			"description"=> "",
			"stockPrewarning"=> "0",
			"pieceMeasureUnit"=> "",
			"havePieceUnit"=> "102",
			"pieceUnitPrice"=> "",
			"packageScaledValue"=> "",
			"pieceScaledValue"=> "",
			"exciseDutyCode"=> "",
			"haveOtherUnit"=> ""
		];
		$items = [];
		array_push($items, $item);

		return $this->request("T130",$items);
	}

	public function goodsUpdate($item)
	{

		$item = [
			"operationType" => "102",
			"goodsName" => $item->name,
			"goodsCode" => $item->efris_item_code,
			"measureUnit"=> $item->uom->external_value,
			"unitPrice" => $item->selling_price,
			"currency"=> "101",
			"commodityCategoryId"=> $item->efris_category->commodityCategoryCode,
			"haveExciseTax"=> "102",
			"description"=> "",
			"stockPrewarning"=> "0",
			"pieceMeasureUnit"=> "",
			"havePieceUnit"=> "102",
			"pieceUnitPrice"=> "",
			"packageScaledValue"=> "",
			"pieceScaledValue"=> "",
			"exciseDutyCode"=> "",
			"haveOtherUnit"=> ""
		];
		$items = [];
		array_push($items, $item);

		return $this->request("T130",$items);
	}

	public function systemDictionaryUpdate()
	{
		$response = $this->request('T115');

		if ($response->code == "00") {
			$response->data = json_decode(gzdecode($response->data, false));
		}

		return $response;
	}

	public function invoicesInquiry()
	{
		$content = [
			"invoiceType" => "1",
			"invoiceKind" => "1",
			"isInvalid" => "1",
			"isRefund" => "1",
			"startDate" => "2019-06-14",
			"endDate" => "2019-06-15",
			"pageNo" => "1",
			"pageSize" => "10",
		];




		return $this->request("T106",$content);
	}

	function request($interface, $content= [])
	{
		// $request_content = "";
		if ($this->mode == "Offline") {
			$content = (sizeof($content) <= 0)? '': base64_encode(json_encode($content));

			$request_content = $content;
			$signature = "";
		}else{
			$content = (sizeof($content) <= 0)? '': json_encode($content);
		
			$request_content = $content;

			$passowrdDes = $this->passowrdDes();
			if ($passowrdDes->code != "00") {
				return $passowrdDes;
			}
			$passowrdDes = json_decode($passowrdDes->data)->passowrdDes;

			$aes = $this->getAESKey($passowrdDes);
			// return $aes;

			$content = $this->encrypt($aes, $content);
			// return $content;

			$pi_key = $this->getPrivKey();
			// return $pi_key;

			$signature = base64_encode($this->sign($content,$pi_key));
		}
		

		$curl = curl_init();

		$request = [
			"data" => [
				"content" => $content,
				"signature" =>  $signature,
				"dataDescription" => [
					"codeType" => "0",
					"encryptCode" => "1",
					"zipCode" => "0"
				]
			],
			"globalInfo" => [
				"appId" => $this->appId,
				"version" => "1.1.20191201",
				"dataExchangeId" => "9230489223014123",
				"interfaceCode" => $interface,
				"requestCode" => "TP",
				"requestTime" => date("Y-m-d H:i:s"),
				"responseCode" => "TA",
				"userName" => "admin",
				"deviceMAC" => "FFFFFFFFFFFF",
				"deviceNo" => $this->deviceNo,
				"tin" => $this->tin,
				"brn" => "",
				"taxpayerID" => "1",
				"longitude" => "116.397128",
				"latitude" => "39.916527",
				"extendField" => [
					"responseDateFormat" => "dd/MM/yyyy",
					"responseTimeFormat" => "dd/MM/yyyy HH:mm:ss"
				]
			],
			"returnStateInfo" => [
				"returnCode" => "",
				"returnMessage" => ""
			]
		];		

		$request_structure = $request;
		$request_structure["data"]["content"] = $request_content;
		$request_structure = json_encode($request_structure);

		$request = json_encode($request);

		// return $request_structure;

	
		curl_setopt_array(
			$curl,
			[
				CURLOPT_URL => $this->url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_SSL_VERIFYPEER => false,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $request,
				CURLOPT_HTTPHEADER => [
					'Content-Type: application/json'
				]
			]
		);

		$response = curl_exec($curl);

		if (curl_errno($curl)) {
			$error_msg = curl_error($curl);
		}
		curl_close($curl);

		$result = new \stdClass;

		// return $response;

		if ($response) {
			$response = json_decode($response,false);
			$result->code = $response->returnStateInfo->returnCode;
			if ($result->code == "00" || $result->code == "45") {
				if ($this->mode == "Online") {
					$result->data = $this->decrypt(base64_decode($aes), $response->data->content);
				}else{
					$result->data = base64_decode($response->data->content);
				}
				
			}
			$result->message = $response->returnStateInfo->returnMessage;

		}else{
			$result->code = "99";
			$result->message = $error_msg;
		}

		return $result;
	}

	function passowrdDes($interface ="T104", $content= [])
	{
		$interface = "T104";
		$content = (sizeof($content) <= 0)? '': base64_encode(json_encode($content));

		$curl = curl_init();

		$request = [
			"data" => [
				"content" => $content,
				"signature" => "",
				"dataDescription" => [
					"codeType" => "0",
					"encryptCode" => "1",
					"zipCode" => "0"
				]
			],
			"globalInfo" => [
				"appId" => "AP04",
				"version" => "1.1.20191201",
				"dataExchangeId" => "9230489223014123",
				"interfaceCode" => $interface,
				"requestCode" => "TP",
				"requestTime" => date("Y-m-d H:i:s"),
				"responseCode" => "TA",
				"userName" => "admin",
				"deviceMAC" => "FFFFFFFFFFFF",
				"deviceNo" => $this->deviceNo,
				"tin" => $this->tin,
				"brn" => "",
				"taxpayerID" => "1",
				"longitude" => "116.397128",
				"latitude" => "39.916527",
				"extendField" => [
					"responseDateFormat" => "dd/MM/yyyy",
					"responseTimeFormat" => "dd/MM/yyyy HH:mm:ss"
				]
			],
			"returnStateInfo" => [
				"returnCode" => "",
				"returnMessage" => ""
			]
		];

		$request = json_encode($request);

		// return $request;

		curl_setopt_array(
			$curl,
			[
				CURLOPT_URL => $this->url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_SSL_VERIFYPEER => false,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $request,
				CURLOPT_HTTPHEADER => [
					'Content-Type: application/json'
				]
			]
		);

		$response = curl_exec($curl);

		if (curl_errno($curl)) {
			$error_msg = curl_error($curl);
		}
		curl_close($curl);

		$result = new \stdClass;

		// return $response;

		if ($response) {
			$response = json_decode($response,false);
			$result->code = $response->returnStateInfo->returnCode;
			if ($result->code == "00") {
				$result->data = base64_decode($response->data->content);
			}
			$result->message = $response->returnStateInfo->returnMessage;

		}else{
			$result->code = "99";
			$result->message = $error_msg;
		}

		return $result;
	}

	function getPrivKey() {
        // read private key
        $cert_store = file_get_contents("storage/certificates/".$this->private_key);
        openssl_pkcs12_read($cert_store, $cert_info, $this->passpharse);
        return $cert_info['pkey'];
    }

    function getAESKey($passowrdDess){
        $pi_key = $this->getPrivKey();
        openssl_private_decrypt(base64_decode($passowrdDess), $key, $pi_key);
        return $key;
    }

    function encrypt($key,$stringVal){
        $encrypted_string = openssl_encrypt($stringVal, "AES-128-ECB",
            base64_decode($key));
        return $encrypted_string;
    }

    function decrypt($key,$encrypted_string)
    {

        $decrypted_string = openssl_decrypt($encrypted_string, "AES-128-ECB",
            $key);
        return $decrypted_string;
    }
    function  sign ($encrypted_string,$pi_key){
        openssl_sign($encrypted_string, $Signature,$pi_key );
        return $Signature;
    }
}
?>